package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.experiment;


import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-70573")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Отправка эксперимента для картиночного баннера")
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfExperimetWithImageBannerTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_REGULAR;
    private static final String EXPERIMENT_JSON = "{\"feild1\":\"value1\"}";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Context context;
    private static Campaign campaign;
    private static int shard;
    private static long additionsId;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Long imageId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(bid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        additionsId = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveAdditionsItemExperiments(Long.valueOf(User.get(LOGIN).getClientID()), EXPERIMENT_JSON);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps()
                .saveBannerAdditions(bid, additionsId, BannersAdditionsAdditionsType.experiment);

        Long bidWithoutDisclaimer = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutDisclaimer);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
    }

    @AfterClass
    public static void clear() {
        if (additionsId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteBannerAdditions(
                    bid, additionsId
            );
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannerAdditionsSteps().deleteAdditionsItemExperiments(
                    additionsId
            );
        }
    }

    @Test
    @Title("Отправка баннера с картинкой и экспериментом, проверка текстовой части")
    public void transportTwoВannersWithExperimentTextBanner() {
        Banner banner = getBsClientDataBanner(campaign, pid, bid);
        assumeThat("в БК отправлена текстовая часть баннера", banner, notNullValue());
        assumeThat("в БК отправлена текстовая часть баннера c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле Experiment первого баннера соответствует ожидаемому",
                banner.getResources().getExperiment(), equalTo(EXPERIMENT_JSON));
    }

    @Test
    @Title("Отправка баннера с картинкой и экспериментом, проверка картиночной части")
    public void transportTwoВannersWithExperimentPictureBanner() {
        Banner banner = getBsClientDataBanner(campaign, pid, imageId);
        assumeThat("в БК отправлена картиночная часть баннера", banner, notNullValue());
        assumeThat("в БК отправлена картиночная часть баннера c UpdateInfo=1", banner.getUpdateInfo(), equalTo(1));
        assertThat("поле DynamicDisclaimer второго баннера соответствует ожидаемому",
                banner.getResources().getExperiment(), equalTo(EXPERIMENT_JSON));
    }
}
