package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.flags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.matchers.flags.AgeMatcher.transportAgeCompliesWithDb;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК параметра Age (возрастная метка)")
@Stories(StoriesNames.BANNER_PARAMS_FLAGS)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfAgeInNewBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String flagsDb;

    @Parameterized.Parameters(name = "Флаги модерации в БД = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {ModerationFlag.AGE_0.getDbValue()},
                {ModerationFlag.AGE_16.getDbValue()},
                {ModerationFlag.MEDICINE.getDbValue() + "," + ModerationFlag.AGE_6.getDbValue()},
                {ModerationFlag.AGE_12.getDbValue() + "," + ModerationFlag.MEDICINE.getDbValue()},
                {ModerationFlag.ABORTION.getDbValue() + ","
                        + ModerationFlag.AGE_16.getDbValue() + "," + ModerationFlag.MEDICINE.getDbValue()},
                {ModerationFlag.ABORTION.getDbValue() + "," + ModerationFlag.BABY_FOOD_8.getDbValue()},
                {ModerationFlag.ABORTION.getDbValue()},
                {null}
        };
        return Arrays.asList(data);
    }

    @Test
    @Title("Отправка в БК параметра Age (возрастная метка)")
    public void testTransportOfAgeInNewBanner() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().setBannersFlags(bid, flagsDb);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());

        assertThat("параметр Age (возрастная метка) соответствует ожидаемому",
                banner.getAge(), transportAgeCompliesWithDb(flagsDb));
    }
}
