package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.flags;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.util.Arrays;
import java.util.Collection;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК параметра Flags (флаги модерации) (1)")
@Stories(StoriesNames.BANNER_PARAMS_FLAGS)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfFlagsInNewBannerTest1
        extends BsTransportOfFlagsInNewBannerBaseTest {

    @Parameterized.Parameters(name = "Флаги модерации в БД = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][] {
                {null},
                {ModerationFlag.ABORTION.getKey()},
                {ModerationFlag.ALCOHOL.getKey()},
                {ModerationFlag.TOBACCO.getKey()},
                {ModerationFlag.DIETARY_SUPPL.getKey()},
                {ModerationFlag.TRAGIC.getKey()},
                {ModerationFlag.PSEUDO_WEAPON.getKey()},
                {ModerationFlag.PROJECT_DECLARATION.getKey()},
        };
        return Arrays.asList(data);
    }
}
