package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.flags;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.util.Arrays;
import java.util.Collection;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК параметра Flags (флаги модерации) (2)")
@Stories(StoriesNames.BANNER_PARAMS_FLAGS)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfFlagsInNewBannerTest2
        extends BsTransportOfFlagsInNewBannerBaseTest {

    @Parameterized.Parameters(name = "Флаги модерации в БД = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {ModerationFlag.AGE_0.getDbValue()},
                {ModerationFlag.AGE_18.getDbValue()},
                {ModerationFlag.BABY_FOOD_0.getDbValue()},
                {ModerationFlag.BABY_FOOD_12.getDbValue()},
                {ModerationFlag.ALCOHOL.getDbValue() + "," + ModerationFlag.BABY_FOOD_4.getDbValue()
                        + "," + ModerationFlag.DIETARY_SUPPL.getDbValue()},
                {ModerationFlag.ALCOHOL.getDbValue() + "," + ModerationFlag.AGE_6.getDbValue()
                        + "," + ModerationFlag.DIETARY_SUPPL.getDbValue()},
                {ModerationFlag.AGE_12.getDbValue() + "," + ModerationFlag.TOBACCO.getDbValue()
                        + "," + ModerationFlag.BABY_FOOD_8.getDbValue()},
                {ModerationFlag.BABY_FOOD_8.getDbValue() + "," + ModerationFlag.PSEUDO_WEAPON.getDbValue()
                        + "," + ModerationFlag.AGE_16.getDbValue()},
        };
        return Arrays.asList(data);
    }
}
