package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.flags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.matchers.flags.FlagsMatcher.transportFlagsCompliesWithDb;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 21.12.15.
 * https://st.yandex-team.ru/TESTIRT-8061
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК параметра Flags (флаги модерации) (Медицина)")
@Stories(StoriesNames.BANNER_PARAMS_FLAGS)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-49651")
@RunWith(Parameterized.class)
public class BsTransportOfMedicineFlagsInNewBannerTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @Parameterized.Parameter(0)
    public String flagsDb;

    @Parameterized.Parameter(1)
    public String expectedFlags;

    @Parameterized.Parameters(name = "Флаги модерации в БД = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {ModerationFlag.MEDICINE.getKey(), ModerationFlag.MEDICINE.getKey()},
                {ModerationFlag.MED_EQUIPMENT.getKey(), ModerationFlag.MED_EQUIPMENT.getKey()},
                {ModerationFlag.MED_SERVICES.getKey(), ModerationFlag.MED_SERVICES.getKey()},
                {ModerationFlag.PHARMACY.getKey(), ModerationFlag.PHARMACY.getKey()},
        };
        return Arrays.asList(data);
    }

    @Test
    @Title("Отправка в БК параметра Flags (флаги модерации)")
    public void testTransportOfFlagsInNewBanner() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().setBannersFlags(bid, flagsDb);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());

        assertThat("параметр Flags (флаги модерации) соответствует ожидаемому",
                banner.getFlags(), transportFlagsCompliesWithDb(expectedFlags));
    }
}
