package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.greenurl;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 12.04.16.
 * https://st.yandex-team.ru/TESTIRT-8851
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверяем не отправку HrefText для баннеров без Href (с визиткой)")
@Stories(StoriesNames.BANNER_PARAMS_HREF_TEXT)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-42707")
public class BsTransportDisplayUrlForBannersWithContactInfoTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static Banner banner;
    private static DirectJooqDbSteps dbSteps;
    private static int shard;


    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        dbSteps = new DirectJooqDbSteps().useShard(shard);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withHref(null)
                                        .withVCardId(vCardId))
                                .withAdGroupId(pid),
                        LOGIN);

        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
    }

    @Test
    public void testBannerHrefText() {
        assumeThat("баннер отправляется с href", banner.getHref(), notNullValue());
        assumeThat("баннер отправляется с UpdateInfo=1", banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assertThat("HrefText не отправляется", banner.getHrefText(), nullValue());
    }


}
