package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.greenurl;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerDisplayHrefsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 11.04.16.
 * https://st.yandex-team.ru/TESTIRT-8851
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Description("Транспорт: проверяем и отправку баннера с отображаемой ссылкой при разных статусах модерации")
@Stories(StoriesNames.BANNER_PARAMS_HREF_TEXT)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-42707")
@RunWith(Parameterized.class)
public class BsTransportDisplayUrlVariousStatusModerationTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String DISPLAY_URL = "myGreenUrl";

    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static Banner banner;
    private static DirectJooqDbSteps dbSteps;

    @Parameterized.Parameter(0)
    public BannerDisplayHrefsStatusmoderate statusModerate;

    @Parameterized.Parameter(1)
    public Matcher matcher;

    @Parameterized.Parameters(name = "Статус модерации = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {BannerDisplayHrefsStatusmoderate.Ready, nullValue()},
                {BannerDisplayHrefsStatusmoderate.Sending, nullValue()},
                {BannerDisplayHrefsStatusmoderate.Sent, nullValue()},
                {BannerDisplayHrefsStatusmoderate.No, nullValue()},
                {BannerDisplayHrefsStatusmoderate.Yes, equalTo(DISPLAY_URL)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        dbSteps = new DirectJooqDbSteps().useShard(shard);
    }

    @Before
    @Step("Создаем баннер с отображаемой ссылкой и отправляем в БК")
    public void prepare() {

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withDisplayUrlPath(DISPLAY_URL))
                                .withAdGroupId(pid),
                        LOGIN);

        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        dbSteps.bannerDisplayHrefsSteps().updateStatusModeration(bid, statusModerate);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        banner = context.getBanner(bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());
    }

    @Test
    public void testBannerHrefText() {
        assumeThat("баннер отправляется с href", banner.getHref(), notNullValue());
        assumeThat("баннер отправляется с UpdateInfo=1", banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));

        assertThat("значение HrefText соответствует ожиданиям"
                , banner.getHrefText(), matcher);
    }


}
