package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.href;

import java.util.List;
import java.util.Map;

import javax.util.streamex.StreamEx;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.HrefMacros;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.lang.String.format;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6315
 * https://st.yandex-team.ru/TESTIRT-8688
 * https://st.yandex-team.ru/TESTIRT-10595
 */
@RunWith(Parameterized.class)
public abstract class BaseBsTransportOfHrefWithMacrosTest {
    static final String PARAMETERIZED = "Значение в Href баннера = {0}, отправляемый макрос = {1}";

    // на сколько тестов дробим. должно совпадать собственно с числом тестов :) и каждый должен использовать свою часть
    // приходится идти на эту хитрость из-за огромного размера логов, вешающих акву
    private static final int BUCKETS_NUM = 8;

    static final Map<Integer, List<Object[]>> CASES = StreamEx.of(HrefMacros.values())
            .mapToEntry(Enum::ordinal)
            .invert()
            .mapKeys(o -> o % BUCKETS_NUM)
            .mapValues(m -> new Object[]{m.getValue(), m.getMacros()})
            .grouping();

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static Long cid;
    private Long bid;
    private Long pid;
    private String href;
    private static String[] imageHashes;


    @Parameterized.Parameter(0)
    public String value;

    @Parameterized.Parameter(1)
    public String macros;

    @BeforeClass
    public static void configImages() {
        imageHashes = helpSteps.addImagesForUserIfNotExists(login, ImageType.REGULAR);
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(login);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .campaignsSteps()
                .updateHrefParams(cid, null);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long keywordId = api.userSteps.keywordsSteps().addRandomKeyword(pid);
        href = format("http://test.yandex.ru/value={%s}", value);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withHref(href))
                .withAdGroupId(pid));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }


    @Test
    @Title("Отправка макроса в поле Href в обычном баннере")
    public void checkMacrosInBannerHref() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный макрос",
                banner.getHref(), equalTo(href.replaceAll(value, macros)));
    }

    @Test
    @Title("Отправка макроса в поле Href в баннере из шаблона параметров href_params на уровне кампании")
    public void checkMacrosInBannerHrefFromHrefParamsOnCampaign() {
        href = "http://test.yandex.ru/";
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(bid)
                        .withTextAd(new TextAdUpdateMap()
                                .withHref(href))));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        String href_params = format("value={%s}", value);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .updateHrefParams(cid, href_params);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный макрос",
                banner.getHref(), equalTo((href + "?" + href_params).replaceAll(value, macros)));
    }

    @Test
    @Title("Отправка макроса в поле Href в картиночном баннере")
    public void checkMacrosInImageBannerHref() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(bid)
                .withTextAd(new TextAdUpdateMap().withAdImageHash(imageHashes[0]))));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(bid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner imageBanner = context != null ? context.getBanner(imageId) : null;
        assumeThat("в БК отправлен баннер", imageBanner, notNullValue());
        assertThat("в БК отправлен правильный макрос",
                imageBanner.getHref(), equalTo(href.replaceAll(value, macros)));
    }
}
