package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.href;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by hmepas on 06.08.18.
 * https://st.yandex-team.ru/DIRECT-78409
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК макроса с имененм кампании в поле Href баннера")
@Stories(StoriesNames.BANNER_PARAMS_HREF)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-78409")
public class BsTransportOfHrefWithCampaignNameInUrlTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final String HREF = "http://test.yandex.ru/";
    private static final String PARAMS = "camp_name={" + HrefOpeningParams.CAMPAIGN_NAME + "}"
            + "&campname={" + HrefOpeningParams.CAMPAIGNNAME + "}"
            + "&camp_name_lat={" + HrefOpeningParams.CAMPAIGN_NAME_LAT + "}"
            + "&campnamelat={" + HrefOpeningParams.CAMPAIGNNAMELAT + "}";

    private static final String CAMPAIGN_NAME = "Galaxy ♠♣♥♦✓ҰЎ Очень длинное имя кампании, точно длиннее 60ти символов. Много букав, очень много букав";
    // https://www.urlencoder.org
    // Помним что укорачивание по границе слова
    private static final String EXPECTED_CAMPAIGN_NAME = "Galaxy%20%D2%B0%D0%8E%20%D0%9E%D1%87%D0%B5%D0%BD%D1%8C%20%D0%B4%D0%BB%D0%B8%D0%BD%D0%BD%D0%BE%D0%B5%20%D0%B8%D0%BC%D1%8F%20%D0%BA%D0%B0%D0%BC%D0%BF%D0%B0%D0%BD%D0%B8%D0%B8%2C%20%D1%82%D0%BE%D1%87%D0%BD%D0%BE%20%D0%B4%D0%BB%D0%B8%D0%BD%D0%BD%D0%B5%D0%B5%2060%D1%82%D0%B8";
    private static final String EXPECTED_CAMPAIGN_NAME_LAT = "Galaxy_Ochen_dlinnoe_imya_kampanii__tochno_dlinnee_60ti";

    private static final String EXPECTED_HREF = "http://test.yandex.ru/" +
            "?camp_name=" + EXPECTED_CAMPAIGN_NAME
            + "&campname=" + EXPECTED_CAMPAIGN_NAME
            + "&camp_name_lat=" + EXPECTED_CAMPAIGN_NAME_LAT
            + "&campnamelat=" + EXPECTED_CAMPAIGN_NAME_LAT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long bid;
    private Long pid;

    @BeforeClass
    public static void configImages() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareBannerForBSExport() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withHref(HREF))
                .withAdGroupId(pid));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        CampaignsRecord campaignRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        campaignRecord.setName(CAMPAIGN_NAME);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(campaignRecord);
    }


    @Test
    @Title("Отправка макросов campaign_name, campaign_name_lat в поле Href в обычном баннере")
    public void checkMacrosInBannerHref() {
        updateBannerHrefAndModerate(HREF + "?" + PARAMS);

        Banner banner = getBannerSentToBs();
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный макрос",
                banner.getHref(), equalTo(EXPECTED_HREF)
        );
    }

    @Test
    @Title("Отправка макроса в поле Href в баннере из шаблона параметров на уровне кампании")
    public void checkMacrosInBannerHrefWithParams() {
        updateBannerHrefAndModerate(HREF);
        api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .campaignsSteps().updateHrefParams(cid, PARAMS);

        Banner banner = getBannerSentToBs();
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный макрос",
                banner.getHref(), equalTo(EXPECTED_HREF)
        );
    }

    private void updateBannerHrefAndModerate(String href) {
        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap().withHref(href))
                ));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
    }

    private Banner getBannerSentToBs() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        return context != null ? context.getBanner(bid) : null;
    }
}
