package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.lang;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersLanguage;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.BELARUSIAN;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.ENGLISH;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.GERMAN;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.KAZAKH;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.RUSSIAN;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.TURKISH;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.UKRAINIAN;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage.UZBEK;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-104366")
@Title("Транспорт: проверка отправки в БК языка баннера")
@Stories(StoriesNames.BANNER_PARAMS_LANG)
@Features({FeatureNames.BANNERS})
@RunWith(Parameterized.class)
public class BsTransportBannerLanguageTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String TEXT_IN_RUSSIAN = "текст на русском";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String languageDbValue;

    @Parameterized.Parameter(1)
    public String languageTransportValue;

    @Parameterized.Parameters(name = "язык баннера: {0}")
    public static Collection<Object[]> languages() {
        Object[][] data = new Object[][]{
                {RUSSIAN.dbValue(), RUSSIAN.transportValue()},
                {ENGLISH.dbValue(), ENGLISH.transportValue()},
                {UKRAINIAN.dbValue(), UKRAINIAN.transportValue()},
                {GERMAN.dbValue(), GERMAN.transportValue()},
                {KAZAKH.dbValue(), KAZAKH.transportValue()},
                {TURKISH.dbValue(), TURKISH.transportValue()},
                {BELARUSIAN.dbValue(), BELARUSIAN.transportValue()},
                {UZBEK.dbValue(), UZBEK.transportValue()},

                {"No", RUSSIAN.transportValue()},
                {"Yes", RUSSIAN.transportValue()},
                {"unknown", RUSSIAN.transportValue()},
        };
        return Arrays.asList(data);
    }

    private static DirectJooqDbSteps jooqDbSteps;

    private static int shard;

    private static Long campaignId;
    private Long adGroupId;
    private Long bannerId;

    @BeforeClass
    public static void beforeClass() {
        jooqDbSteps = new DirectJooqDbSteps().useShardForLogin(LOGIN);
        shard = jooqDbSteps.getCurrentPpcShard();

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(campaignId);
    }

    @Before
    public void before() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withText(TEXT_IN_RUSSIAN))
                .withAdGroupId(adGroupId), null);
        Long keywordId = api.userSteps.keywordsSteps().addRandomKeyword(adGroupId);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bannerId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    public void testLanguage() {
        setLanguage(languageDbValue);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, campaignId);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, campaignId);
        Banner banner = campaign.getContext(adGroupId).getBanner(bannerId);

        assertThat(banner.getLang(), is(languageTransportValue));
    }

    private void setLanguage(BannersLanguage bannersLanguage) {
        BannersRecord bannersRecord = jooqDbSteps.bannersSteps().getBanner(bannerId);
        bannersRecord.setLanguage(bannersLanguage);
        jooqDbSteps.bannersSteps().updateBanners(bannersRecord);
    }

    private void setLanguage(String bannerLanguage) {
        setLanguage(BannersLanguage.valueOf(bannerLanguage.equals("ru") ? bannerLanguage + "_" : bannerLanguage));
    }
}
