package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.lang;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 15.12.15.
 * https://st.yandex-team.ru/TESTIRT-8041
 * учет национальных символов описан здесь https://st.yandex-team.ru/DIRECT-66699
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: отправка в БК поля Lang баннера на основе автоопределения")
@Stories(StoriesNames.BANNER_PARAMS_LANG)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-48272")
@RunWith(Parameterized.class)
public class BsTransportOfBannerLangTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Banner banner;

    @Parameterized.Parameter(0)
    public String title;
    @Parameterized.Parameter(1)
    public String titleExtension;
    @Parameterized.Parameter(2)
    public String body;
    @Parameterized.Parameter(3)
    public Long regionId;
    @Parameterized.Parameter(4)
    public BannerLanguage expectedLang;

    @Parameterized.Parameters(name = "заголовок 1 = {0}, заголовок 2 = {1}, текст = {2}, ожидаемый язык = {4}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Заголовок", null, "Текст баннера", RegionIDValues.RUSSIA.getId().longValue(), BannerLanguage.RUSSIAN},
                {"Заголовок", "Второй заголовок", "Текст баннера", RegionIDValues.RUSSIA.getId().longValue(),
                        BannerLanguage.RUSSIAN},
                {"Заголовок", "Реклама на українському мовою", "Текст баннера",
                        RegionIDValues.UKRAINE.getId().longValue(), BannerLanguage.UKRAINIAN},
                {"Title", null, "Body text", RegionIDValues.ENGLAND.getId().longValue(), BannerLanguage.ENGLISH},
                {"Тақырыбы", null, "Жарнама қазақ тілінде", RegionIDValues.KAZAKHSTAN.getId().longValue(),
                        BannerLanguage.KAZAKH},
                {"Überschrift ö", null, "Erklärung ß", RegionIDValues.EUROPE.getId().longValue(),
                        BannerLanguage.GERMAN}, //Üü и Öö есть и в турецком, но Ää и ß только в немецком
                {"Başlık", null, "Metin afiş", RegionIDValues.TURKEY.getId().longValue(), BannerLanguage.TURKISH},
                {"Назва", null, "Реклама на українському мовою", RegionIDValues.UKRAINE.getId().longValue(),
                        BannerLanguage.UKRAINIAN},
                {"Яндэкс.Таксі", null, "Аплата наяўнымі і картай", RegionIDValues.BELARUS.getId().longValue(),
                        BannerLanguage.BELARUSIAN}
        });
    }

    @BeforeClass
    public static void init() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(cid)
                        .withDefaultGroup(AdGroupType.BASE)
                        .withRegionIds(regionId));
        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withText(body)
                        .withTitle(title)
                        .withTitle2(titleExtension)
                ));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Проверяем, что отправляемый Banner.Lang вычисляется по символам из Title и Text")
    public void checkBannerLang() {
        assertThat("отправляемый в БК язык баннера соответсвует ожиданиям", banner.getLang()
                , equalTo(expectedLang.toString()));
    }
}
