package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.lang;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 20.05.16.
 * https://st.yandex-team.ru/TESTIRT-9312
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверяем, автоопределение языка для Banner.Lang делается на основе только Body & Title")
@Description("Заполняем callouts, sitelinks, displayUrl на языке отличным от Body & Title; " +
        "Ожидаем автоопределение языка в Banner.Lang на основе Body & Title")
@Stories(StoriesNames.BANNER_PARAMS_LANG)
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-48272")
@RunWith(Parameterized.class)
public class BsTransportOfBannerWithAdditionsLangTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private static DirectJooqDbSteps dbSteps;
    private Banner banner;

    @Parameterized.Parameter(0)
    public String title;
    @Parameterized.Parameter(1)
    public String body;
    @Parameterized.Parameter(2)
    public Long regionId;
    @Parameterized.Parameter(3)
    public String calloutText;
    @Parameterized.Parameter(4)
    public String siteLinksText;
    @Parameterized.Parameter(5)
    public String greenUrlText;
    @Parameterized.Parameter(6)
    public BannerLanguage expectedLang;


    @Parameterized.Parameters(name = "заголовок = {0}, текст = {1}, ожидаемый язык = {6}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Заголовок", "Текст баннера", RegionIDValues.RUSSIA.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS).replace(" ", ""), BannerLanguage.RUSSIAN},
                {"Title", "Body text", RegionIDValues.ENGLAND.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.ENGLISH},
                {"Тақырыбы", "Жарнама қазақ тілінде", RegionIDValues.KAZAKHSTAN.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.TURKEY_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.KAZAKH},
                {"Überschrift ö", "Erklärung ß", RegionIDValues.EUROPE.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.TURKEY_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.GERMAN}, //Üü и Öö есть и в турецком, но Ää и ß только в немецком
                {"Başlık", "Metin afiş", RegionIDValues.TURKEY.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.TURKISH},
                {"Назва", "Реклама на українському мовою", RegionIDValues.UKRAINE.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.UKRAINIAN},
                {"беларускі Яндэкс.Таксі", "Аплата наяўнымі і картай", RegionIDValues.BELARUS.getId().longValue(),
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS).replace(" ", ""),
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS).replace(" ", ""), BannerLanguage.BELARUSIAN},
        });
    }

    @BeforeClass
    public static void init() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        dbSteps = new DirectJooqDbSteps().useShard(shard);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(cid)
                        .withDefaultGroup(AdGroupType.BASE)
                        .withRegionIds(regionId));

        //добавляем одно уточнение
        Long calloutIds = api.userSteps.adExtensionsSteps().addCalloutWithText(calloutText);
        dbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(calloutIds, AdditionsItemCalloutsStatusmoderate.Yes);

        List<Long> sitelinksSetIds = api.userSteps.sitelinksSteps().add(new AddRequestMap().withSitelinksSets(
                new SitelinksSetAddItemMap().withSitelinks(
                        new SitelinkMap().randomSitelinkWithDescription().withDescription(siteLinksText))));
        assumeThat("добавлен набор сайтлинков", sitelinksSetIds, hasSize(1));

        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withText(body)
                        .withTitle(title)
                        .withDisplayUrlPath(greenUrlText)
                        .withAdExtensionIds(calloutIds)
                        .withSitelinkSetId(sitelinksSetIds.get(0))
                ));

        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);


        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Проверяем, что отправляемый Banner.Lang вычисляется по символам из Title и Text")
    public void checkBannerLang() {
        assertThat("отправляемый в БК язык баннера соответсвует ожиданиям", banner.getLang()
                , equalTo(expectedLang.toString()));
    }

}
