package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import java.util.ArrayList;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.ReflectedAttributes;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.directapi.model.User.get;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultAdgroupsMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultBannersMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultCampaignsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 12/08/15.
 * https://st.yandex-team.ru/TESTIRT-6659
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-42673")
@Title("Транспорт: баннеры с типом mobile_content" +
        ", поля HideContentIcon, HideStoreContentRating, HideStoreContentPrice, HideContentReviewCount")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfMobileBannerHideContentTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @Rule
    public MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private static Banner banner;

    private static Banner cpcVideoBanner;

    private static Banner imageAdBanner;

    @Parameterized.Parameter(0)
    public String reflectedAttrs;

    @Parameterized.Parameter(1)
    public int[] expected; //0 - ICON; 1 - PRICE; 2 - RATING; 3 - RATING_VOTES;

    @Parameterized.Parameters(name = "attributes = {0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = new ArrayList<>();
        data.add(new Object[]{
                ReflectedAttributes.ICON.toString()
                , new int[]{0, 1, 1, 1}
        });
        data.add(new Object[]{
                ReflectedAttributes.PRICE.toString()
                , new int[]{1, 0, 1, 1}
        });
        data.add(new Object[]{
                ReflectedAttributes.RATING.toString()
                , new int[]{1, 1, 0, 1}
        });
        data.add(new Object[]{
                ReflectedAttributes.RATING_VOTES.toString()
                , new int[]{1, 1, 1, 0}
        });

        data.add(new Object[]{
                ReflectedAttributes.RATING.toString() + "," + ReflectedAttributes.ICON.toString()
                , new int[]{0, 1, 0, 1}
        });
        data.add(new Object[]{
                ReflectedAttributes.RATING_VOTES.toString() + "," + ReflectedAttributes.PRICE.toString()
                , new int[]{1, 0, 1, 0}
        });
        data.add(new Object[]{
                ReflectedAttributes.RATING_VOTES.toString() + "," + ReflectedAttributes.PRICE.toString() + ","
                        + ReflectedAttributes.RATING.toString() + "," + ReflectedAttributes.ICON.toString()
                , new int[]{0, 0, 0, 0}
        });
        data.add(new Object[]{
                ""
                , new int[]{1, 1, 1, 1}
        });
        return data;
    }


    @Before
    @Step("Подготовка данных")
    public void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        api.userSteps.getDirectJooqDbSteps().ppcPropertiesSteps()
                .insertPropertyValue("show_reflected_attrs_for_all_mobile_banners", "true");
        MobileContentRecord sendingMobileContent
                = getDefaultMobileContent(get(LOGIN).getClientID());
        Long mobileContentId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().saveMobileContent(sendingMobileContent);

        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        long creativeId = api.userSteps.getDirectJooqDbSteps().perfCreativesSteps()
                .saveDefaultCpcVideoCreative(clientId);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        Long cpcVideoBid = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(pid, creativeId);
        Long imageAdBid = api.userSteps.adsSteps().addDefaultMobileAppImageAd(pid, adImageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(cpcVideoBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(imageAdBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, cpcVideoBid, BannersPerformanceStatusmoderate.Yes);
        api.userSteps.getDirectJooqDbSteps().perfCreativesSteps()
                .setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        cleanupRule.setMobileContentIds(singletonList(mobileContentId));
        cleanupRule.setPids(singletonList(pid));
        cleanupRule.setShard(shard);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateCampaignsMobileContent(
                        getDefaultCampaignsMobileContent(cid)
                );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateAdgroupsMobileContent(
                        getDefaultAdgroupsMobileContent(pid, mobileContentId)
                );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateBannersMobileContent(
                        getDefaultBannersMobileContent(bid).setReflectedAttrs(reflectedAttrs)
                );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());

        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());

        banner = context.getBanner(bid);
        cpcVideoBanner = context.getBanner(cpcVideoBid);
        imageAdBanner = context.getBanner(imageAdBid);

        assumeThat("в контексте присутствует Banner", banner, notNullValue());
        assumeThat("в контексте присутствует cpcVideoBanner", cpcVideoBanner, notNullValue());
        assumeThat("в контексте присутствует imageAdBanner", imageAdBanner, notNullValue());
        assumeThat("Правильное значение флага", api.userSteps.getDirectJooqDbSteps().ppcPropertiesSteps()
                .getPropertyValue("show_reflected_attrs_for_all_mobile_banners"), is("true"));
    }

    @Test
    public void testTransportOfBannerMobileContentAction() {
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HideContentIcon"
                , banner.getHideContentIcon()
                , equalTo(expected[0]));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HideStoreContentPrice"
                , banner.getHideStoreContentPrice()
                , equalTo(expected[1]));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HideStoreContentRating"
                , banner.getHideStoreContentRating()
                , equalTo(expected[2]));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HideContentReviewCount"
                , banner.getHideContentReviewCount()
                , equalTo(expected[3]));
    }

    @Test
    public void testTransportOfCpcVideoMobileBannerAction() {
        assertThat("при отправке баннера с типом cpc_video отправляется правильное значение HideContentIcon"
                , cpcVideoBanner.getHideContentIcon()
                , equalTo(0));
        assertThat("при отправке баннера с типом cpc_video отправляется правильное значение HideStoreContentPrice"
                , cpcVideoBanner.getHideStoreContentPrice()
                , equalTo(0));
        assertThat("при отправке баннера с типом cpc_video отправляется правильное значение HideStoreContentRating"
                , cpcVideoBanner.getHideStoreContentRating()
                , equalTo(0));
        assertThat("при отправке баннера с типом cpc_video отправляется правильное значение HideContentReviewCount"
                , cpcVideoBanner.getHideContentReviewCount()
                , equalTo(0));
    }

    @Test
    public void testTransportOfImageAdMobileBannerAction() {
        assertThat("при отправке баннера с типом image_ad отправляется правильное значение HideContentIcon"
                , imageAdBanner.getHideContentIcon()
                , equalTo(0));
        assertThat("при отправке баннера с типом image_ad отправляется правильное значение HideStoreContentPrice"
                , imageAdBanner.getHideStoreContentPrice()
                , equalTo(0));
        assertThat("при отправке баннера с типом image_ad отправляется правильное значение HideStoreContentRating"
                , imageAdBanner.getHideStoreContentRating()
                , equalTo(0));
        assertThat("при отправке баннера с типом image_ad отправляется правильное значение HideContentReviewCount"
                , imageAdBanner.getHideContentReviewCount()
                , equalTo(0));
    }
}

