package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentOsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.directapi.model.User.get;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultAdgroupsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 12/08/15.
 * https://st.yandex-team.ru/TESTIRT-6659
 * https://st.yandex-team.ru/TESTIRT-7034
 * https://st.yandex-team.ru/DIRECT-45820
 * https://st.yandex-team.ru/TESTIRT-10161
 * https://st.yandex-team.ru/DIRECT-73936
 * https://st.yandex-team.ru/DIRECT-75388
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-42673")
@Title("Транспорт: баннеры с типом mobile_content, поле Href")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfMobileBannerHrefTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final String ADJUST = "adjust";
    private static final String APPMETRICA = "appmetrica";
    private static final String APPSFLYER = "appsflyer";
    private static final String BRANCH = "branch";
    private static final String FLURRY = "flurry";
    private static final String KOCHAVA = "kochava";
    private static final String MAT_TUNE = "mat_tune";
    private static final String MYTRACKER = "mytracker";
    private static final String SINGULAR = "singular";
    private static final String UNKNOWN = "_unknown_";

    private static final String IOS_STORE_HREF = "https://apps.apple.com/ru/app/angry-birds/id343200656?mt=8";
    private static final String ANDROID_STORE_HREF = "https://play.google.com/store/apps/details?id=com.cocoplay.fashion.style&hl=ru&gl=US";

    private static final String CAMPAIGN_NAME = "Имя кампании";
    private static final String EXPECTED_CAMPAIGN_NAME = "%D0%98%D0%BC%D1%8F%20%D0%BA%D0%B0%D0%BC%D0%BF%D0%B0%D0%BD%D0%B8%D0%B8";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule

    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @Rule
    public MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private static Long cid;
    private static Banner banner;

    @Parameterized.Parameter(0)
    public MobileContentOsType os;

    @Parameterized.Parameter(1)
    public String trackingLink;

    @Parameterized.Parameter(2)
    public String expectedMobileTracker;

    @Parameterized.Parameter(3)
    public String expectedTrackingLink;

    @Parameterized.Parameter(4)
    public String expectedTrackingLinkS2S;

    @Parameterized.Parameter(5)
    public String storeLink;

    @Parameterized.Parameter(6)
    public String expectedStoreLinkS2S;

    @Parameterized.Parameters(name = "{2} {0} trackingLink = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {
                    MobileContentOsType.iOS,
                    "app.adjust.com/z5zbnp",
                    ADJUST,
                    "http://app.adjust.com/z5zbnp?idfa={IDFA_UC}&ya_click_id={TRACKID}",
                    "http://app.adjust.com/z5zbnp?idfa={IDFA_UC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "app.adjust.com/z5zbnp",
                    ADJUST,
                    "http://app.adjust.com/z5zbnp?gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}",
                    "http://app.adjust.com/z5zbnp?gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}&external_click_id=YandexDirectInt_{TRACKID}",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF + "&referrer=adjust_external_click_id%3DYandexDirectInt_{TRACKID}",
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adjust.io/z5zbnp",
                    ADJUST,
                    "http://app.adjust.io/z5zbnp?idfa={IDFA_UC}&ya_click_id={TRACKID}",
                    "http://app.adjust.io/z5zbnp?idfa={IDFA_UC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adjust.io/z5zbnp",
                    ADJUST,
                    "http://app.adjust.io/z5zbnp?gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}",
                    "http://app.adjust.io/z5zbnp?gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}&external_click_id=YandexDirectInt_{TRACKID}",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF + "&referrer=adjust_external_click_id%3DYandexDirectInt_{TRACKID}",
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adjust.com/z5zbnp?key=value",
                    ADJUST,
                    "http://app.adjust.com/z5zbnp?key=value&idfa={IDFA_UC}&ya_click_id={TRACKID}",
                    "http://app.adjust.com/z5zbnp?key=value&idfa={IDFA_UC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adjust.com/z5zbnp?key=value",
                    ADJUST,
                    "http://app.adjust.com/z5zbnp?key=value&gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}",
                    "http://app.adjust.com/z5zbnp?key=value&gps_adid={GOOGLE_AID_LC}&oaid={OAID_LC}&ya_click_id={TRACKID}&ip_address={CLIENTIP}&language={DEVICE_LANG}&s2s=1&user_agent={USER_AGENT}&external_click_id=YandexDirectInt_{TRACKID}",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF + "&referrer=adjust_external_click_id%3DYandexDirectInt_{TRACKID}",
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adj.st/z5zbnp",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_idfa={IDFA_UC}&adj_ya_click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adj.st/z5zbnp",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_gps_adid={GOOGLE_AID_LC}&adj_oaid={OAID_LC}&adj_ya_click_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adj.st/z5zbnp?adj_ya_click_id={logid}",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_idfa={IDFA_UC}&adj_ya_click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adj.st/z5zbnp?adj_ya_click_id={logid}",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_gps_adid={GOOGLE_AID_LC}&adj_oaid={OAID_LC}&adj_ya_click_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adj.st/z5zbnp?adjust_idfa={ios_ifa}&adj_ya_click_id={logid}",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adjust_idfa={IDFA_UC}&adj_idfa={IDFA_UC}&adj_ya_click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adj.st/z5zbnp?adjust_gps_adid={google_aid}&adj_ya_click_id={logid}",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adjust_gps_adid={GOOGLE_AID_LC}&adj_gps_adid={GOOGLE_AID_LC}&adj_oaid={OAID_LC}&adj_ya_click_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adj.st/z5zbnp?install_callback=http%3A%2F%2Fpostback.yandexadexchange.net%2Fpostback",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_idfa={IDFA_UC}&adj_ya_click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adj.st/z5zbnp?install_callback=http%3A%2F%2Fexample.com%2Fpostback",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?install_callback=http%3A%2F%2Fexample.com%2Fpostback&adj_gps_adid={GOOGLE_AID_LC}&adj_oaid={OAID_LC}&adj_ya_click_id={TRACKID}".replaceAll("%", "%%"),
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.adj.st/z5zbnp?conversion_callback=http%3A%2F%2Fpostback.yandexadexchange.net%2Fpostback",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?adj_idfa={IDFA_UC}&adj_ya_click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.adj.st/z5zbnp?conversion_callback=http%3A%2F%2Fexample.com%2Fpostback",
                    ADJUST,
                    "http://app.adj.st/z5zbnp?conversion_callback=http%3A%2F%2Fexample.com%2Fpostback&adj_gps_adid={GOOGLE_AID_LC}&adj_oaid={OAID_LC}&adj_ya_click_id={TRACKID}".replaceAll("%", "%%"),
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://ad.apps.fm?i=935669243&l=en",
                    FLURRY,
                    "https://ad.apps.fm?i=935669243&l=en&ios_idfa={IDFA_UC}&click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://ad.apps.fm?i=935669243&l=en",
                    FLURRY,
                    "https://ad.apps.fm?i=935669243&l=en&adid={GOOGLE_AID_LC}&click_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "appmetrika.yandex.ru",
                    UNKNOWN,
                    "http://appmetrika.yandex.ru",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "appmetrika.yandex.ru",
                    UNKNOWN,
                    "http://appmetrika.yandex.ru",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://193303.measurementapi.com/serve?action=click&publisher_id=193303&site_id=94096&offer_id=395655",
                    MAT_TUNE,
                    "https://193303.measurementapi.com/serve?action=click&publisher_id=193303&site_id=94096&offer_id=395655&ios_ifa={IDFA_UC}&publisher_ref_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://193303.measurementapi.com/serve?action=click&publisher_id=193303&site_id=94096&offer_id=395655",
                    MAT_TUNE,
                    "https://193303.measurementapi.com/serve?action=click&publisher_id=193303&site_id=94096&offer_id=395655&google_aid={GOOGLE_AID_LC}&publisher_ref_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.appsflyer.com/id569251594",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?idfa={IDFA_UC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    "http://app.appsflyer.com/id569251594?idfa={IDFA_UC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&af_ip={CLIENTIP}&af_lang={DEVICE_LANG}&af_ua={USER_AGENT}&redirect=false&c=%2$s",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.appsflyer.com/id569251594",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    "http://app.appsflyer.com/id569251594?advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&af_ip={CLIENTIP}&af_lang={DEVICE_LANG}&af_ua={USER_AGENT}&redirect=false&af_ref=YandexDirectInt_{TRACKID}&c=%2$s",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF + "&referrer=YandexDirectInt_{TRACKID}",
                },
                {
                    MobileContentOsType.iOS,
                    "http://app.appsflyer.com/id569251594?af_ios_url=some_af_ios_url",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?af_ios_url=some_af_ios_url&idfa={IDFA_UC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.appsflyer.com/id569251594?some_param=some_value&af_android_url=some_af_android_url",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?some_param=some_value&af_android_url=some_af_android_url&advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.appsflyer.com/id569251594?af_android_url=some_af_android_url",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?af_android_url=some_af_android_url&advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.appsflyer.com/id569251594?af_r=some_af_r",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?af_r=some_af_r&advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://app.appsflyer.com/id569251594?af_dp=some_af_dp",
                    APPSFLYER,
                    "http://app.appsflyer.com/id569251594?af_dp=some_af_dp&advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "http://chineseg.onelink.me/BCIV/e8a87aa7",
                    APPSFLYER,
                    "http://chineseg.onelink.me/BCIV/e8a87aa7?idfa={IDFA_UC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "http://chineseg.onelink.me/BCIV/e8a87aa7",
                    APPSFLYER,
                    "http://chineseg.onelink.me/BCIV/e8a87aa7?advertising_id={GOOGLE_AID_LC}&oaid={OAID_LC}&af_c_id=%1$s&clickid={TRACKID}&pid=yandexdirect_int&c=%2$s",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618",
                    APPMETRICA,
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618?ios_ifa={IDFA_UC}&click_id={TRACKID}",
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618?ios_ifa={IDFA_UC}&click_id={TRACKID}&click_timestamp={CURRENT_UNIXTIME}&device_ip={CLIENTIP}&device_ua={USER_AGENT}&noredirect=1",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618",
                    APPMETRICA,
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618?google_aid={GOOGLE_AID_LC}&click_id={TRACKID}",
                    "https://redirect.appmetrica.yandex.ru/serve/1177615213269101618?google_aid={GOOGLE_AID_LC}&click_id={TRACKID}&click_timestamp={CURRENT_UNIXTIME}&device_ip={CLIENTIP}&device_ua={USER_AGENT}&noredirect=1",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF,
                },
                {
                    MobileContentOsType.iOS,
                    "https://7654321.redirect.appmetrica.yandex.ru/serve/1177615213269101618",
                    APPMETRICA,
                    "https://7654321.redirect.appmetrica.yandex.ru/serve/1177615213269101618?ios_ifa={IDFA_UC}&click_id={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://7654321.redirect.appmetrica.yandex.com/serve/1177615213269101618",
                    APPMETRICA,
                    "https://7654321.redirect.appmetrica.yandex.com/serve/1177615213269101618?google_aid={GOOGLE_AID_LC}&click_id={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://control.kochava.com/v1/cpi/click?campaign_id=qwerty12",
                    KOCHAVA,
                    "https://control.kochava.com/v1/cpi/click?campaign_id=qwerty12&ios_idfa={IDFA_UC}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://control.kochava.com/v1/cpi/click?campaign_id=qwerty12",
                    KOCHAVA,
                    "https://control.kochava.com/v1/cpi/click?campaign_id=qwerty12&adid={GOOGLE_AID_LC}&android_id={ANDROID_ID_LC}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://trk.mail.ru/c/qwerty1234",
                    MYTRACKER,
                    "https://trk.mail.ru/c/qwerty1234?mt_idfa={IDFA_UC}&clickId={TRACKID}&regid={TRACKID}",
                    "https://trk.mail.ru/c/qwerty1234?mt_idfa={IDFA_UC}&clickId={TRACKID}&regid={TRACKID}",
                    IOS_STORE_HREF,
                    IOS_STORE_HREF,
                },
                {
                    MobileContentOsType.Android,
                    "https://trk.mail.ru/c/qwerty1234",
                    MYTRACKER,
                    "https://trk.mail.ru/c/qwerty1234?mt_gaid={GOOGLE_AID_LC}&clickId={TRACKID}&regid={TRACKID}",
                    "https://trk.mail.ru/c/qwerty1234?mt_gaid={GOOGLE_AID_LC}&clickId={TRACKID}&regid={TRACKID}",
                    ANDROID_STORE_HREF,
                    ANDROID_STORE_HREF,
                },
                {
                    MobileContentOsType.iOS,
                    "https://some.app.link/qwerty1234",
                    BRANCH,
                    "https://some.app.link/qwerty1234?%%24idfa={IDFA_UC}&~click_id={TRACKID}&%%243p=a_yandex_direct",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://some.app.link/qwerty1234",
                    BRANCH,
                    "https://some.app.link/qwerty1234?%%24aaid={GOOGLE_AID_LC}&~click_id={TRACKID}&%%243p=a_yandex_direct",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://some.sng.link/qwe/rty",
                    SINGULAR,
                    "https://some.sng.link/qwe/rty?idfa={IDFA_UC}&cl={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://some.sng.link/qwe/rty",
                    SINGULAR,
                    "https://some.sng.link/qwe/rty?aifa={GOOGLE_AID_LC}&andi={ANDROID_ID_LC}&oaid={OAID_LC}&cl={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    "https://absolutely-unknown-tracker.com/id569251594?clickid={logid}",
                    UNKNOWN,
                    "https://absolutely-unknown-tracker.com/id569251594?clickid={TRACKID}",
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    "https://absolutely-unknown-tracker.com/id569251594?clickid={logid}",
                    UNKNOWN,
                    "https://absolutely-unknown-tracker.com/id569251594?clickid={TRACKID}",
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.iOS,
                    null,
                    UNKNOWN,
                    IOS_STORE_HREF,
                    null,
                    IOS_STORE_HREF,
                    null,
                },
                {
                    MobileContentOsType.Android,
                    null,
                    UNKNOWN,
                    ANDROID_STORE_HREF,
                    null,
                    ANDROID_STORE_HREF,
                    null,
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных")
    public void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        MobileContentRecord sendingMobileContent
                = getDefaultMobileContent(get(LOGIN).getClientID()).setOsType(os);
        Long mobileContentId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().saveMobileContent(sendingMobileContent);

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        CampaignsRecord campaignRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        campaignRecord.setName(CAMPAIGN_NAME);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(campaignRecord);

        cleanupRule.setMobileContentIds(singletonList(mobileContentId));
        cleanupRule.setPids(singletonList(pid));
        cleanupRule.setShard(shard);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .bannersSteps().getBanner(bid).setHref(trackingLink)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateAdgroupsMobileContent(
                        getDefaultAdgroupsMobileContent(pid, mobileContentId).setStoreContentHref(storeLink)
                );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());

        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());

        banner = context.getBanner(bid);

        assumeThat("в контексте присутствует Banner", banner, notNullValue());

    }

    @Test
    public void testTransportOfBannerMobileHref() {
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение MobileTracker"
                , banner.getMobileTracker(), equalTo(expectedMobileTracker));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение Href"
                , banner.getHref(), equalTo(formatExpectedLink(expectedTrackingLink)));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HrefS2S"
                , banner.getHrefS2S(), equalTo(formatExpectedLink(expectedTrackingLinkS2S)));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение ContentStoreHref"
                , banner.getContentStoreHref(), equalTo(storeLink));
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение ContentStoreHrefS2S"
                , banner.getContentStoreHrefS2S(), equalTo(expectedStoreLinkS2S));
    }

    private String formatExpectedLink(String expectedLink) {
        return Objects.isNull(expectedLink) ? null : String.format(expectedLink, cid, EXPECTED_CAMPAIGN_NAME);
    }
}

