package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.CustomMatcher;

import org.hamcrest.Description;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Sitelink;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.directapi.model.User.get;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultAdgroupsMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultBannersMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultCampaignsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-139083")})
@Title("Транспорт: баннеры с типом mobile_content, поля Sitelinks")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features(FeatureNames.BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfMobileBannerSitelinksTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String PPC_PROPERTY_NAME = "MOBILE_APP_BANNERS_SITELINKS_ENABLED_PERCENT";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @Rule
    public MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private Campaign campaign;
    private Banner banner;

    @Parameterized.Parameter()
    public Boolean sitelinksEnabled;

    @Parameterized.Parameters(name = "sitelinksEnabled = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{true}, {false}};
        return Arrays.asList(data);
    }

    private static CustomMatcher<Sitelink> sitelinkMatcher(String title, String description, String href) {
        return new CustomMatcher<Sitelink>(title) {
            @Override
            public boolean matches(Object item) {
                Sitelink sitelink = (Sitelink) item;
                return sitelink.getTitle().equals(title)
                        && sitelink.getDescription().equals(description)
                        && sitelink.getHref().equals(href);
            }
        };
    }

    @Before
    @Step("Подготовка данных")
    public void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        MobileContentRecord sendingMobileContent
                = getDefaultMobileContent(get(LOGIN).getClientID());
        Long mobileContentId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().saveMobileContent(sendingMobileContent);

        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        cleanupRule.setMobileContentIds(singletonList(mobileContentId));
        cleanupRule.setPids(singletonList(pid));
        cleanupRule.setShard(shard);

        Long percent = cid % 100;
        if (sitelinksEnabled) {
            percent += 1;
        }
        api.userSteps.getDirectJooqDbSteps().useShard(shard).ppcPropertiesSteps()
                .updatePropertyValue(PPC_PROPERTY_NAME, percent.toString());

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());

        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());

        banner = context.getBanner(bid);

        assumeThat("в контексте присутствует Banner", banner, notNullValue());
    }

    @Test
    public void testTransportOfBannerMobileContentSitelinks() {
        if (sitelinksEnabled) {
            assertThat("при отправке баннера с типом mobile_content отправляется правильное количество Sitelinks",
                    banner.getSitelinks(), hasSize(4));
            assertThat("при отправке баннера с типом mobile_content отправляются правильные Sitelinks",
                    banner.getSitelinks(), containsInAnyOrder(
                            sitelinkMatcher("Рейтинг и отзывы", "Посмотреть рейтинг приложения и отзывы", banner.getHref()),
                            sitelinkMatcher("О приложении", "Описание приложения и скриншоты", banner.getHref()),
                            sitelinkMatcher("Что нового", "Новая функциональность и доработки", banner.getHref()),
                            sitelinkMatcher("Дополнительная информация", "Разработчик приложения, категория, системные требования", banner.getHref())
                    ));
        } else {
            assertThat("при отправке баннера с типом mobile_content не отправляется никаких Sitelinks",
                    banner.getSitelinks(), empty());
        }
    }
}

