package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.directapi.model.User.get;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultAdgroupsMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultBannersMobileContent;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultCampaignsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 12/08/15.
 * https://st.yandex-team.ru/TESTIRT-6659
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-42673"),
        @Issue("https://st.yandex-team.ru/DIRECT-60917")})
@Title("Транспорт: баннеры с типом mobile_content, поля MobileAppId, HideDomain, TemplateId")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfMobileBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @ClassRule
    public static MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static RunBsTransportScriptResponse resp;
    private static Banner banner;
    private static Long mobileContentId;

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        MobileContentRecord sendingMobileContent
                = getDefaultMobileContent(get(LOGIN).getClientID());
        mobileContentId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().saveMobileContent(sendingMobileContent);

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultMobileAppAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        cleanupRule.setMobileContentIds(singletonList(mobileContentId));
        cleanupRule.setPids(singletonList(pid));
        cleanupRule.setShard(shard);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateCampaignsMobileContent(
                        getDefaultCampaignsMobileContent(cid)
                );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateAdgroupsMobileContent(
                        getDefaultAdgroupsMobileContent(pid, mobileContentId)
                );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateBannersMobileContent(
                        getDefaultBannersMobileContent(bid)
                );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());

        banner = getBsClientDataBanner(campaign,pid,bid);
        assumeThat("в контексте присутствует Banner", banner, notNullValue());

    }

    @Test
    public void testTransportOfBannerMobileAppId() {
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение MobileAppId"
                , banner.getMobileAppID(), equalTo(mobileContentId));
    }

    @Test
    public void testTransportOfBannerHideDomain() {
        assertThat("при отправке баннера с типом mobile_content отправляется правильное значение HideDomain"
                , banner.getHideDomain(), equalTo("1"));
    }

    @Test
    public void testTransportOfBannerHrefText() {
        assertThat("при отправке баннера с типом mobile_content не отправляется поле HrefText"
                , banner.getHrefText(), nullValue());
    }

    @Test
    @Description("проверяем, что в первом запросе баннер отправляется с полем TemplateID=320")
    //https://st.yandex-team.ru/TESTIRT-10837
    public void testOfMobileContentBannerTemplateId320Req1() {
        assertThat("TemplateID в баннере соответсвует ожиданиям",
                banner.getTemplateId(),
                equalTo(BannerTemplateId.PPC_TEMPLATE_ID.value()));
    }

    @Test
    @Description("проверяем, что во втором запросе баннер отправляется без поля TemplateID")
    //https://st.yandex-team.ru/TESTIRT-10837
    public void testOfMobileContentBannerTemplateId320Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid, bid, 1);
        assertThat("ключ TemplateID отсутствует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }
}

