package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.MobileContentUtils;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.images.BannerWideImagesMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultCampaignsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by pashkus on 22.03.16.
 * https://st.yandex-team.ru/TESTIRT-8807
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Title("Транспорт: создание РМП баннера (type= mobile_content) с картинкой")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewMobileBannerWithImageTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_WIDE;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private static RunBsTransportScriptResponse resp;
    private static Long cid;
    private static Long adGroupId;
    private static Long adImageId;


    @BeforeClass
    @Step("Подготовка тестовых данных:\n" +
            "создаем РМП кампанию; прикрепляем картинку типа WIDE")
    public static void before() {
        TransportHelpSteps transportHelpSteps = new TransportHelpSteps(api);

        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String[] imageHashes = transportHelpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.WIDE);
        String associatedHash = imageHashes[0];

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        Long adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withAdGroupId(adGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withAdImageHash(associatedHash))
        );
        BannerImagesRecord bannerImage = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(adId);
        adImageId = bannerImage.getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateCampaignsMobileContent(getDefaultCampaignsMobileContent(cid.intValue()));

        MobileContentRecord updatedMobileContent = MobileContentUtils
                .getDefaultMobileContent(User.get(LOGIN).getClientID());
        updatedMobileContent.setMobileContentId(api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .getAdGroupMobileContent(adGroupId).getMobileContentId());

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .mobileContentSteps().updateMobileContent(updatedMobileContent);

        //модерируем все что можно
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(adId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(bannerImage.getImageHash(), BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        resp = api.userSteps.transportSteps().sendNewCampaign(shard, cid);
    }

    @Test
    @Description("[1й запрос] Проверяем, что картиночный баннер содержит все необходмые форматы")
    public void testOfImageFormatsInBannerForMobileApps() {
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign != null ? campaign.getContext(adGroupId) : null;
        Banner imageBanner = context != null ? context.getBanner(adImageId) : null;

        assert(imageBanner != null);
        assertThat("форматы картинок в баннере WIDE соответсвуют ожиданиям",
                imageBanner.getImages(),
                BannerWideImagesMatcher.isValid());
    }


    @Test
    @Description("[2й запрос] Проверяем, что баннер РМП с картинкой включился")
    public void testOfImageBannerForMobileAppsExists() {
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, 1, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign != null ? campaign.getContext(adGroupId) : null;
        Banner imageBanner = context != null ? context.getBanner(adImageId) : null;

        assert(context != null);
        assumeThat("в БК отправляются 2 баннера", context.getBanners().size(), equalTo(2));
        assertThat("баннер с картинкой включен", imageBanner.getStop(), equalTo(0));
    }
}
