package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.mobile;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.MobileContentUtils;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.MobileContentCleanupRule;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultCampaignsMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 23.03.16.
 * https://st.yandex-team.ru/TESTIRT-8807
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Title("Отвязываем картинку у синхронизированного РМП баннера (type= mobile_content)")
@Stories(StoriesNames.BANNER_PARAMS_MOBILE_CONTENT)
@Features({FeatureNames.BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfUpdateMobileBannerByDeletingImageTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_WIDE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public MobileContentCleanupRule cleanupRule = new MobileContentCleanupRule(api);

    private static RunBsTransportScriptResponse resp;
    private static Long cid;
    private static Long adGroupId;
    private static Long adId;
    private static Long adImageId;


    @BeforeClass
    @Step("Подготовка тестовых данных:\n" +
            "создаем РМП кампанию с картиночным баннером; синхронизируем; отвязываем картинку от баннера; синхронизируем")
    public static void before() {
        TransportHelpSteps transportHelpSteps = new TransportHelpSteps(api);

        Integer shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String[] imageHashes = transportHelpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.WIDE);
        String associatedHash = imageHashes[0];

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withAdGroupId(adGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withAdImageHash(associatedHash))
        );
        BannerImagesRecord bannerImage = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(adId);
        adImageId = bannerImage.getImageId();

        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps()
                .updateCampaignsMobileContent(getDefaultCampaignsMobileContent(cid.intValue()));

        MobileContentRecord updatedMobileContent = MobileContentUtils
                .getDefaultMobileContent(User.get(LOGIN).getClientID());
        updatedMobileContent.setMobileContentId(api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .getAdGroupMobileContent(adGroupId).getMobileContentId());

        api.userSteps.getDirectJooqDbSteps().useShard(shard).mobileContentSteps().updateMobileContent(updatedMobileContent);

        //модерируем все что можно
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(adId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerate(bannerImage.getImageHash(), BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        //отправка новой кампании в БК
        api.userSteps.transportSteps().sendNewCampaign(shard, cid);


        api.userSteps.adsSteps().adsUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .withAdImageHash(null)
                        ))
        );

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.NO);

        //обновление кампании в БК (c отвязанной картинкой)
        resp = api.userSteps.transportSteps().sendCampaign(shard, cid);
    }

    @Test
    @Description("[1й запрос] Проверяем, что некартиночный баннер включен")
    public void testOfBannerForMobileAppsSentActive() {
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign != null ? campaign.getContext(adGroupId) : null;
        Banner textBanner = context != null ? context.getBanner(adId) : null;

        assertThat("отправляем в БК включенный текстовый баннер",
                textBanner.getStop(),
                equalTo(StopFlag.RESUME.value()));
    }


    @Test
    @Description("[1й запрос] Проверяем, что баннеро с картинкой выключается")
    public void testOfImageBannerForMobileAppsSentInactive() {
        Campaign campaign = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign != null ? campaign.getContext(adGroupId) : null;
        Banner imageBanner = context != null ? context.getBanner(adImageId) : null;

        assertThat("баннер с картинкой выключен", imageBanner.getStop(), equalTo(StopFlag.STOP.value()));
    }
}
