package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.permalink;

import org.apache.commons.lang.math.RandomUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPermalinksPermalinkAssignType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.OrganizationsStatusPublish;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.OrganizationsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPermalinksPermalinkAssignType.auto;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPermalinksPermalinkAssignType.manual;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.OrganizationsStatusPublish.published;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.OrganizationsStatusPublish.unpublished;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId.PPC_TEMPLATE_ID;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId.PPC_TEMPLATE_ID_NEW;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andreymak on 19.01.2017.
 * https://st.yandex-team.ru/TESTIRT-10916
 * тест кейсы 3 и 4
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-60678")
@Title("Транспорт: проверка отправки Banner.Permalink")
@Stories(StoriesNames.BANNER_PARAMS_PERMALINK)
@Features(FeatureNames.BANNERS)
public class BsTransportOfPermalinkTextAdTest {
    private static final String login = Logins.LOGIN_TRANSPORT;
    private static long clientId;
    private static TransportSteps transportSteps;
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static DirectJooqDbSteps jooqDbSteps;

    private long cid;
    private long pid;
    private long bid;
    private Long permalink;
    private Long chainId;
    private Context context;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        clientId = Long.valueOf(api.userSteps.clientFakeSteps().getClientData(login).getClientID());
        transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        Long vcardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        TextAdAddMap textAdAddMap = new TextAdAddMap().defaultTextAd()
                .withTurboPageId(null)
                .withVCardId(vcardId)
                .withHref(null);
        AdAddItemMap adAddItemMap = new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(textAdAddMap);
        bid = api.userSteps.adsSteps().addAd(adAddItemMap);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
    }

    @Title("Промодерированная визитка и автопривязанный пермалинк")
    @Test
    public void vcardAndAutoPermalink_vcardAndPermalinkSentToBs() {
        permalink = assignPermalinkOrChain(auto, false);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер должен иметь визитку", banner.getContactInfo(), notNullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь пустой PermalinkChainId", banner.getChainIds(), empty());
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("Промодерированная визитка и чейн")
    @Test
    public void vcardAndChain_vcardAndChainSentToBs() {
        chainId = assignPermalinkOrChain(auto, true);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер должен иметь визитку", banner.getContactInfo(), notNullValue());
        assertThat("баннер не должен иметь Permalink", banner.getPermalink(), nullValue());
        assertThat("баннер должен иметь корректный PermalinkChainId", banner.getChainIds(), contains(chainId));
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("Промодерированная визитка и ручной неопубликованный пермалинк")
    @Test
    public void vcardAndManualUnpublishedPermalink_notSentNoBs() {
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, unpublished);
        context = sendToBsAndGetContext();

        assertThat("Группа и баннер не должны быть отправлен в БК", context, nullValue());
    }

    @Title("Промодерированная визитка, ручной неопубликованный пермалинк и чейн")
    @Test
    public void vcardAndManualUnpublishedPermalinkAndChain_notSentNoBs() {
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, unpublished);
        chainId = assignPermalinkOrChain(auto, true);
        context = sendToBsAndGetContext();

        assertThat("Группа и баннер не должны быть отправлен в БК", context, nullValue());
    }

    @Title("Промодерированная визитка, ручной неопубликованный пермалинк, ссылка и чейн")
    @Test
    public void vcardAndManualUnpublishedPermalinkAndChainAndHref_chainSentToBs() {
        addHref();
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, unpublished);
        chainId = assignPermalinkOrChain(auto, true);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер не должен иметь визитку", banner.getContactInfo(), nullValue());
        assertThat("баннер не должен иметь Permalink", banner.getPermalink(), nullValue());
        assertThat("баннер должен иметь корректный PermalinkChainId", banner.getChainIds(), contains(chainId));
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(), equalTo(PPC_TEMPLATE_ID.value()));
    }

    @Title("Промодерированная визитка, ручной опубликованный пермалинк")
    @Test
    public void vcardAndManualPublishedPermalink_permalinkSentToBs() {
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, published);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер не должен иметь визитку", banner.getContactInfo(), nullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь пустой PermalinkChainId", banner.getChainIds(), empty());
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
        assertThat("banner.getDomainFilter()", banner.getDomainFilter(), equalTo(permalink.toString()));
    }

    @Title("Промодерированная визитка, ручной опубликованный пермалинк, приоритет визитки")
    @Test
    public void vcardAndManualPublishedPermalink_preferVCardOverPermalink_permalinkAndVCardSentToBs() {
        permalink = assignPermalinkOrChain(manual, false);
        setPreferVCardOverPermalink();
        addOrganization(permalink, published);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер должен иметь визитку", banner.getContactInfo(), notNullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь пустой PermalinkChainId", banner.getChainIds(), empty());
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("Промодерированная визитка и ручной неопубликованный пермалинк, приоритет визитки")
    @Test
    public void vcardAndManualUnpublishedPermalink_preferVCardOverPermalink_onlyVCardSentToBs() {
        permalink = assignPermalinkOrChain(manual, false);
        setPreferVCardOverPermalink();
        addOrganization(permalink, unpublished);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер должен иметь визитку", banner.getContactInfo(), notNullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), nullValue());
        assertThat("баннер должен иметь пустой PermalinkChainId", banner.getChainIds(), empty());
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("Промодерированная визитка, ручной опубликованный пермалинк и чейн")
    @Test
    public void vcardAndManualPublishedPermalinkAndChain_permalinkAndChainSentToBs() {
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, published);
        chainId = assignPermalinkOrChain(auto, true);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер не должен иметь визитку", banner.getContactInfo(), nullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь корректный PermalinkChainId", banner.getChainIds(), contains(chainId));
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("ручной опубликованный пермалинк")
    @Test
    public void ManualPublishedPermalink_permalinkSentToBs() {
        deleteVcard();
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, published);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер не должен иметь визитку", banner.getContactInfo(), nullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь пустой PermalinkChainId", banner.getChainIds(), empty());
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    @Title("ручной опубликованный пермалинк и чейн")
    @Test
    public void ManualPublishedPermalinkAndChain_permalinkAndChainSentToBs() {
        deleteVcard();
        permalink = assignPermalinkOrChain(manual, false);
        addOrganization(permalink, published);
        chainId = assignPermalinkOrChain(auto, true);
        context = sendToBsAndGetContext();

        assertThat("Группа должна быть отправлена в БК", context, notNullValue());
        Banner banner = context.getBanner(bid);
        assumeThat("баннер должен быть отправлен в БК", banner, notNullValue());
        assertThat("баннер не должен иметь визитку", banner.getContactInfo(), nullValue());
        assertThat("баннер должен иметь корректный Permalink", banner.getPermalink(), equalTo(permalink));
        assertThat("баннер должен иметь корректный PermalinkChainId", banner.getChainIds(), contains(chainId));
        assertThat("баннер содержит правильный TemplateID", banner.getTemplateId(),
                equalTo(PPC_TEMPLATE_ID_NEW.value()));
    }

    /**
     * Отправка в БК и получение контекста
     */
    private Context sendToBsAndGetContext() {
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        RunBsTransportScriptResponse resp = transportSteps.sendNewCampaign(shard, cid);
        Campaign campaign = transportSteps.getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("новая кампания отправлена в БК", campaign, notNullValue());
        return campaign.getContext(pid);
    }

    private void deleteVcard() {
        BannersRecord record = jooqDbSteps.bannersSteps().getBanner(bid);
        record.setVcardId(null);
        jooqDbSteps.bannersSteps().updateBanners(record);
    }

    private void addHref() {
        BannersRecord record = jooqDbSteps.bannersSteps().getBanner(bid);
        record.setHref("http://ya.ru");
        jooqDbSteps.bannersSteps().updateBanners(record);
    }

    private Long assignPermalinkOrChain(BannerPermalinksPermalinkAssignType permalinkType, boolean addChain) {
        Long permalink = addChain ? 0 : RandomUtils.nextLong();
        Long chainId = addChain ? RandomUtils.nextLong() : null;
        jooqDbSteps.bannerAdditionsSteps().setPermalink(bid, permalink, chainId, permalinkType);
        return permalink != 0 ? permalink : chainId;
    }

    private void setPreferVCardOverPermalink() {
        jooqDbSteps.bannerAdditionsSteps().updatePreferVCardOverPermalink(bid, true);
    }

    private void addOrganization(Long permalink, OrganizationsStatusPublish pubStatus) {
        OrganizationsRecord record = new OrganizationsRecord()
                .setPermalinkId(permalink)
                .setStatusPublish(pubStatus)
                .setClientid(clientId);
        jooqDbSteps.bannerAdditionsSteps().addOrUpdateOrganization(record);
    }
}
