package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.permalink;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasKey;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by andreymak on 19.01.2017.
 * https://st.yandex-team.ru/TESTIRT-10916
 * тест кейс 1
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-60678")
@Title("Транспорт: проверка неотправки Banner.Permalink в баннере без визитки")
@Stories(StoriesNames.BANNER_PARAMS_PERMALINK)
@Features(FeatureNames.BANNERS)
public class BsTransportOfPermalinkWithNoContactsTest {
    private static final String login = Logins.LOGIN_TRANSPORT;
    private static Long cid;
    private static Long pid;
    private static Long bidNoVcard;
    private static RunBsTransportScriptResponse resp;

    private static TransportSteps transportSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        // текстовый баннер с промодерированной визиткой с Пермалинком
        bidNoVcard = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                )
        );
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidNoVcard);

        // отправляем в БК
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        resp = transportSteps.sendNewCampaign(shard, cid);
        Campaign campaign = transportSteps.getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("новая кампания отправлена в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("группа отправлена в БК", context, notNullValue());
    }

    @Test
    @Title("Отправка в БК текстового баннера без визитки")
    public void testBannerNoVcard() {
        Map<String, Map> rawRequest =
                transportSteps.getRawClientDataLogRequestForBanner(resp, cid, pid, bidNoVcard);
        assumeThat("текстовый баннер без визитки отправлен в БК",
                rawRequest, notNullValue());
        assertThat("текстовый баннер без визитки отправился без поля Permalink",
                rawRequest, not(hasKey(Banner.PERMALINK)));
    }
}
