package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.templateid;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.BsTransportParameters;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 23/01/17.
 * https://st.yandex-team.ru/TESTIRT-10837
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.UPDATE_DATA)
@Tag(BsTransportParameters.TemplateID)
@Title("Создание и отправка баннеров с разными шаблонами (TemplateID)")
@Issue("https://st.yandex-team.ru/DIRECT-60917")
@Stories(StoriesNames.BANNER_ACTION_CREATION)
@Features(FeatureNames.BANNERS)
public class TestOfTemplateIdOfTextBanners {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Long cid;
    private static Long pid1;
    private static Long pid2;
    private static Long bidWithGeoflag;
    private static Long bid320;
    private static Long bidWithContactInfo;
    private static Long bidWithGeoFlagAndContactInfo;
    private static Long bidWithGeoInfo;

    private static RunBsTransportScriptResponse resp;
    private static Campaign campaignReq1;

    private static final String expectationString = "TemplateID баннера соотв. ожиданиям";

    @BeforeClass
    public static void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();

        //первая группа с таргетигом по-умолчанию (на все)
        pid1 = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid320 = api.userSteps.adsSteps().addDefaultTextAd(pid1);

        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bidWithContactInfo = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid1)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));

        bidWithGeoInfo = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid1)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withHref("http://templateid.ru")));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).vCardSteps().saveFakeDomainVCardsForDomain("templateid.ru");

        Long bidsId1 = api.userSteps.keywordsSteps().addDefaultKeyword(pid1);

        //вторая группа с узким гео-таргетингом (banners.opts <- geoflag)
        pid2 = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(cid)
                        .withRegionIds(Long.parseLong(RegionIDValues.SPB_ID)));
        bidWithGeoflag = api.userSteps.adsSteps().addDefaultTextAd(pid2);

        bidWithGeoFlagAndContactInfo = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid2)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));

        Long bidsId2 = api.userSteps.keywordsSteps().addDefaultKeyword(pid2);

        //фейковая модерация
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid320);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithContactInfo);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithGeoInfo);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId1);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid2);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithGeoflag);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithGeoFlagAndContactInfo);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId2);

        //отправка в БК
        resp = api.userSteps.transportSteps().sendNewCampaign(shard, cid);
        campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }

    @Test
    @Title("1я итерация: проверка TemplateID для текстового баннера со стандартным шаблоном")
    public void testTextBannerTemplateId320Req1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid1, bid320);
        assertThat(expectationString,
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID.value()));
    }

    @Test
    @Title("1я итерация: проверка TemplateID для текстового баннера с ContactInfo (визитка)")
    public void testTextBannerTemplateId410ForContactInfoReq1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid1, bidWithContactInfo);
        assertThat(expectationString,
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_NEW.value()));
    }

    @Test
    @Title("1я итерация: проверка TemplateID для текстового баннера с GeoFlag=1 (узкий регион таргетирования)")
    public void testTextBannerTemplateId269Req1() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid2, bidWithGeoflag);
        assertThat(expectationString,
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_GEO.value()));
    }

    @Test
    @Title("1я итерация: Проверяем порядок вычисления TemplateID. Баннер с визиткой и геофлагом")
    @Description("Для баннера содержащего оба ключа ContactInfo и GeoFlag, ожидаем TemplateID = 410")
    public void testTextBannerTemplateIdPriority() {
        Banner banner = getBsClientDataBanner(campaignReq1, pid2, bidWithGeoFlagAndContactInfo);
        assertThat(expectationString,
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_NEW.value()));
    }

    @Test
    @Title("2я итерация: отправка текстового баннера со стандартным шаблоном")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testTextBannerTemplateId320Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid1, bid320, 1);
        assumeThat("баннер содержит UpdateInfo=0", banner.get(Banner.UPDATE_INFO), equalTo(0));
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }

    @Test
    @Title("2я итерация: отправка текстового баннера с расширенным шаблоном")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testTextBannerTemplateId410ForContactInfoReq2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid1, bidWithContactInfo, 1);
        assumeThat("баннер содержит UpdateInfo=0", banner.get(Banner.UPDATE_INFO), equalTo(0));
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }

    @Test
    @Title("2я итерация: отправка текстового баннера с расширенным шаблоном")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testTextBannerTemplateId410ForGeoInfoReq2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid1, bidWithGeoInfo, 1);
        assumeThat("баннер содержит UpdateInfo=0", banner.get(Banner.UPDATE_INFO), equalTo(0));
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }


    @Test
    @Title("2я итерация: отправка текстового баннера с гео шаблоном")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testTextBannerTemplateId269Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid2, bidWithGeoflag, 1);
        assumeThat("баннер содержит UpdateInfo=0", banner.get(Banner.UPDATE_INFO), equalTo(0));
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }


}
