package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.titlebody;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

public class BannerTitleBodyBaseTest {

    protected static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public TestParam testParam;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<TestParam[]> parameters() {
        return Arrays.asList(
                new TestParam[]{
                        new TestParam("в креативе есть title и body, отправляются они")
                                .withCreativeTitle("test creative title")
                                .withCreativeBody("test creative body")
                                .withExtractedText("extracted text very long text buy pokupay big title body text")
                                .withExpectedTitle("test creative title")
                                .withExpectedBody("test creative body")
                                .withExpectedIsFakeTitle(null)
                                .withExpectedIsFakeBody(null),
                },
                new TestParam[]{
                        new TestParam("в креативе есть body, нет title, вместо title отправляется заглушка")
                                .withCreativeTitle(null)
                                .withCreativeBody("test creative body")
                                .withExtractedText("extracted text very long text buy pokupay big title body text")
                                .withExpectedTitle("picture banner title")
                                .withExpectedBody("test creative body")
                                .withExpectedIsFakeTitle(1)
                                .withExpectedIsFakeBody(null),
                },
                new TestParam[]{
                        new TestParam("в креативе есть title, нет body, вместо body отправляется заглушка")
                                .withCreativeTitle("test creative title")
                                .withCreativeBody(null)
                                .withExtractedText("extracted text very long text buy pokupay big title body text")
                                .withExpectedTitle("test creative title")
                                .withExpectedBody("picture banner body")
                                .withExpectedIsFakeTitle(null)
                                .withExpectedIsFakeBody(1),
                },
                new TestParam[]{
                        new TestParam("в креативе нет title и body, " +
                                "текст от модератора отправляется в Title и Body")
                                .withCreativeTitle(null)
                                .withCreativeBody(null)
                                .withExtractedText("extracted text very long text buy pokupay big title body text")
                                .withExpectedTitle("extracted text very long text buy")
                                .withExpectedBody("pokupay big title body text")
                                .withExpectedIsFakeTitle(null)
                                .withExpectedIsFakeBody(null),
                },
                new TestParam[]{
                        new TestParam("в креативе нет title и body, " +
                                "короткий текст от модератора отправляется в Title, в Body заглушка")
                                .withCreativeTitle(null)
                                .withCreativeBody(null)
                                .withExtractedText("extracted text was short")
                                .withExpectedTitle("extracted text was short")
                                .withExpectedBody("picture banner body")
                                .withExpectedIsFakeTitle(null)
                                .withExpectedIsFakeBody(1),
                }
        );
    }

    protected static class TestParam {
        protected String description;
        String creativeTitle;
        String creativeBody;
        String extractedText;
        String expectedTitle;
        String expectedBody;
        Integer expectedIsFakeTitle;
        Integer expectedIsFakeBody;

        private TestParam(String description) {
            this.description = description;
        }

        private TestParam withCreativeTitle(String creativeTitle) {
            this.creativeTitle = creativeTitle;
            return this;
        }

        private TestParam withCreativeBody(String creativeBody) {
            this.creativeBody = creativeBody;
            return this;
        }

        private TestParam withExtractedText(String extractedText) {
            this.extractedText = extractedText;
            return this;
        }

        private TestParam withExpectedTitle(String expectedTitle) {
            this.expectedTitle = expectedTitle;
            return this;
        }

        private TestParam withExpectedBody(String expectedBody) {
            this.expectedBody = expectedBody;
            return this;
        }

        private TestParam withExpectedIsFakeTitle(Integer expectedIsFakeTitle) {
            this.expectedIsFakeTitle = expectedIsFakeTitle;
            return this;
        }

        private TestParam withExpectedIsFakeBody(Integer expectedIsFakeBody) {
            this.expectedIsFakeBody = expectedIsFakeBody;
            return this;
        }

        @Override
        public String toString() {
            return description;
        }
    }
}
