package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.titlebody;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.UPDATE_DATA)
@Title("Транспорт: отправка Title и Body в баннерах типа cpc_video РМП")
@Stories(StoriesNames.BANNER_PARAMS_TITLEBODY)
@Features(FeatureNames.BANNERS_CPC_VIDEO)
@RunWith(Parameterized.class)
public class MobileAppCpcVideoBannerTitleBodyTest extends BannerTitleBodyBaseTest {

    private DirectJooqDbSteps jooqDbSteps;
    private Long creativeId;
    private Banner banner;

    @Before
    public void setUp() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(clientId);

        long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        long bidId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        ModerationInfo modInfo = new ModerationInfo().generateTestDataWithVideoAddition();
        if (testParam.creativeTitle != null) {
            modInfo.addText("title", testParam.creativeTitle);
        }
        if (testParam.creativeBody != null) {
            modInfo.addText("body", testParam.creativeBody);
        }
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId, modInfo.toString());
        long bid = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(pid, creativeId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidId);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.bannersPerformanceSteps().setCreativeExtractedText(bid, testParam.extractedText);
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());

        Context context = campaign.getContext(pid);
        assumeThat("в БК отправлен контекст", context, notNullValue());
        banner = context.getBanner(bid);
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    public void testMobileAppCpcVideoBannerWithUserTitleBanner() {
        assertThat("Title баннера соответствует ожиданию", banner.getTitle(), is(testParam.expectedTitle));
        assertThat("Body баннера соответствует ожиданию", banner.getBody(), is(testParam.expectedBody));
    }

    @After
    public void tearDown() {
        jooqDbSteps.bannersPerformanceSteps().deleteBannersPerformanceRecord(creativeId);
        jooqDbSteps.perfCreativesSteps().deletePerfCreatives(creativeId);
    }
}

