package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.titleextension;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 05.07.17.
 * https://st.yandex-team.ru/TESTIRT-11527
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Description("Отправка в БК второго заголовка")
@Features(FeatureNames.BANNERS)
@Issue("https://st.yandex-team.ru/DIRECT-67518")
public class BsTransportOfTitleExtensionTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String TITLE_EXTENSION = "Title Extension";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Banner bannerWithTitleExtension;
    private static Map<String, Map> bannerWithoutTitleExtension;

    @BeforeClass
    public static void init() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidWithTitleExtension = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withTitle2(TITLE_EXTENSION))
                                .withAdGroupId(pid),
                        LOGIN);
        Long bidWithoutTitleExtension = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withTitle2(null))
                                .withAdGroupId(pid),
                        LOGIN);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithTitleExtension);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutTitleExtension);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Context context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());
        bannerWithTitleExtension = context.getBanner(bidWithTitleExtension);
        assumeThat("в контексте присутствует Banner", bannerWithTitleExtension, notNullValue());
        bannerWithoutTitleExtension = helpSteps.getBannerMap(resp, cid, pid, bidWithoutTitleExtension);
        assumeThat("в контексте присутствует Banner", bannerWithoutTitleExtension, notNullValue());
    }

    @Test
    public void titleExtensionTest() {
        assumeThat("баннер отправляется с UpdateInfo=1", bannerWithTitleExtension.getUpdateInfo(),
                equalTo(UpdateInfo.UPDATE.value()));
        assertThat("значение TitleExtension соответствует ожиданиям", bannerWithTitleExtension.getTitleExtension(),
                equalTo(TITLE_EXTENSION));
    }

    @Test
    public void noTitleExtensionTest() {
        assertThat("значение TitleExtension соответствует ожиданиям",
                bannerWithoutTitleExtension.containsKey(Banner.TITLE_EXTENSION),
                equalTo(false));
    }
}
