package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.turbogalleries;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertTrue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК поля TurboGalleryHref баннера")
@Stories(StoriesNames.BANNER_PARAMS_TURBO_GALLERY)
@Features(FeatureNames.BANNERS)
public class BsTransportBannerTurboGalleriesTest {

    private static final String TURBO_GALLERY_HREF = "https://yandex.ru/turbo?text=https%3A%2F%2Fkupicase.ru%2Fcategories%2Flenovo-p780&page=0#p1704";
    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private static Long cid;
    private Long bid;
    private Long pid;
    private static DirectJooqDbSteps directJooqDbSteps;

    @BeforeClass
    public static void configImages() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(login);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }

    @After
    public void after() {
        if (bid != null) {
            directJooqDbSteps.bannerTurboGalleriesSteps().deleteBannerTurboGalleryHref(bid);
        }
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        long keywordId = api.userSteps.keywordsSteps().addRandomKeyword(pid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Title("Отправка TurboGalleryHref в ресурсе баннере")
    public void checkTurboGalleryHrefInBannerHref() {
        directJooqDbSteps.bannerTurboGalleriesSteps().setBannerTurboGalleryHref(bid, TURBO_GALLERY_HREF);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        //noinspection ConstantConditions
        assertThat("в БК отправлен правильный ресурс",
                banner.getResources().getTurboGalleryHref(), equalTo(TURBO_GALLERY_HREF));
    }

    @Test
    @Title("Не отправляем TurboGalleryHref, если он не задан")
    public void checkTurboGalleryHrefAbsentWhenNotSet() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        //noinspection ConstantConditions
        assertThat("в БК не отправлен ресурс",
                banner.getResources().getTurboGalleryHref(), nullValue());
    }

    @Test
    @Title("Не отправляем TurboGalleryHref для не ТГО баннера")
    public void checkTurboGalleryHrefAbsentWhenBannerHasWrongType() {
        // Проверим на динамическом объявлении
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        String turboGalleryHref = "turbo_href";
        directJooqDbSteps.bannerTurboGalleriesSteps().setBannerTurboGalleryHref(bid, turboGalleryHref);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        //noinspection ConstantConditions
        assertTrue("в БК не отправлен ресурс",
                banner.getResources() == null || banner.getResources().getTurboGalleryHref() == null);
    }

}
