package ru.yandex.autotests.directintapi.bstransport.main.banner.parameters.turbolanding;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-168790")
@Title("Транспорт: проверка отправки Stop при отклонении принятого ранее турболендинга, если нет других ссылок")
@Stories(StoriesNames.BANNER_PARAMS_TURBOLANDING)
@Features(FeatureNames.BANNERS)
public class BsTransportOfAdWithTurbolandingOnlyStopTest {
    private static final String login = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long clientId;
    private static Integer shard;
    private static Long tlId;
    private static TransportSteps transportSteps;
    private static DirectJooqDbSteps jooqDbSteps;

    public Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(login).getClientID());
        transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        tlId = jooqDbSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
    }

    @Test
    public void rejectTurbolanding_SentStopToBs() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        TextAdAddMap textAdAddMap = new TextAdAddMap().defaultTextAd()
                .withTurboPageId(tlId)
                .withHref(null);
        AdAddItemMap adAddItemMap = new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(textAdAddMap);
        bid = api.userSteps.adsSteps().addAd(adAddItemMap);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        jooqDbSteps.bannerTurbolandingsSteps().setBannerTurbolandingStatusModerate(bid,
                BannerTurbolandingsStatusmoderate.Yes);

        sendToBsFirstTime();

        jooqDbSteps.bannerTurbolandingsSteps().setBannerTurbolandingStatusModerate(bid,
                BannerTurbolandingsStatusmoderate.No);
        Campaign campaign = sendToBsAndGetCampaign();
        Banner banner = (campaign != null) ? campaign.getContext(pid).getBanner(bid) : null;
        assumeThat("Отправка отработала корректно", banner, notNullValue());
        assertThat("На баннере должен уйти Stop: 1", banner.getStop(), is(1));
    }

    private void sendToBsFirstTime() {
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        RunBsTransportScriptResponse resp = transportSteps.sendNewCampaign(shard, cid);
        Campaign campaign = transportSteps.getClientDataRequestCampaign(resp, 0, cid);
        Banner banner = (campaign != null) ? campaign.getContext(pid).getBanner(bid) : null;
        assumeThat("новое объявление отправлено в БК", banner, notNullValue());
    }

    private Campaign sendToBsAndGetCampaign() {
        jooqDbSteps.bannersSteps().setBannerStatusBsSynced(bid, BannersStatusbssynced.No);
        RunBsTransportScriptResponse resp = transportSteps.sendSyncedCampaign(shard, cid);
        return transportSteps.getClientDataRequestCampaign(resp, 0, cid);
    }
}
