package ru.yandex.autotests.directintapi.bstransport.main.campaign.absegments;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.AbSegmentMultiplier;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.AbSegmentMultiplierData;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.HierarchicalMultipliers;
import ru.yandex.autotests.direct.cmd.data.counters.MetrikaCountersData;
import ru.yandex.autotests.direct.cmd.data.savecamp.SaveCampRequest;
import ru.yandex.autotests.direct.cmd.rules.BannersRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CoefDimension;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.CoefDimensionSegment;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра CoefDimensions (корректировки аб-сегментов)")
@Stories(StoriesNames.CAMPAIGN_PARAMS_AB_SEGMENTS)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfAbSegmentCoefTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final Long SECTION_ID = MetrikaCountersData.DEFAULT_COUNTER.getFirstAbSectionId();
    private static final List<Long> SEGMENT_IDS =
            MetrikaCountersData.DEFAULT_COUNTER.getAbSegmentIdsBySectionId().get(SECTION_ID);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private BannersRule bannersRule = new TextBannersRule()
            .overrideCampTemplate(new SaveCampRequest()
                    .withMetrika_counters(MetrikaCountersData.DEFAULT_COUNTER.getCounterId().toString())
                    .withAbSectionsStat(singletonList(SECTION_ID))
                    .withAbSegmentsRetargeting(SEGMENT_IDS)
                    .withHierarchicalMultipliers(new HierarchicalMultipliers()
                            .withAbSegmentMultiplier(new AbSegmentMultiplier()
                                    .withEnabled(true)
                                    .withAbSegments(asList(new AbSegmentMultiplierData()
                                            .withSectionId(SECTION_ID)
                                            .withSegmentId(SEGMENT_IDS.get(0))
                                            .withMultiplierPct("130"), new AbSegmentMultiplierData()
                                            .withSectionId(SECTION_ID)
                                            .withSegmentId(SEGMENT_IDS.get(1))
                                            .withMultiplierPct("140"))))))
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка в БК параметра TargetDimensions (таргетирование аб-сегментов)")
    public void testTransportOfStatDimensions() {
        Long cid = bannersRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        List<CoefDimension> coefDimensions = campaign.getCoefDimensions();
        CoefDimension expectedCoefDimension = new CoefDimension()
                .withDimensionId(SECTION_ID)
                .withSegments(
                        asList(new CoefDimensionSegment().withSegmentId(SEGMENT_IDS.get(0)).withMultiplier(130),
                                new CoefDimensionSegment().withSegmentId(SEGMENT_IDS.get(1)).withMultiplier(140)));

        assertThat("значения корректировок аб-сегментов соответствуют ожидаемым", coefDimensions,
                beanDiffer(singletonList(expectedCoefDimension)).useCompareStrategy(onlyExpectedFields()));
    }
}
