package ru.yandex.autotests.directintapi.bstransport.main.campaign.absegments;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.data.counters.MetrikaCountersData;
import ru.yandex.autotests.direct.cmd.data.savecamp.SaveCampRequest;
import ru.yandex.autotests.direct.cmd.rules.BannersRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.AbSegmentsDimension;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

/**
 *
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра StatDimensions (активные эксперименты)")
@Stories(StoriesNames.CAMPAIGN_PARAMS_AB_SEGMENTS)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfAbSegmentStatisticsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private BannersRule bannersRule = new TextBannersRule()
            .overrideCampTemplate(new SaveCampRequest()
                    .withMetrika_counters(MetrikaCountersData.DEFAULT_COUNTER.getCounterId().toString())
                    .withAbSectionsStat(singletonList(MetrikaCountersData.DEFAULT_COUNTER.getFirstAbSectionId())))
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка в БК параметра StatDimensions (активные эксперименты)")
    public void testTransportOfStatDimensions() {
        Long cid = bannersRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        List<Long> segmentIds = MetrikaCountersData.DEFAULT_COUNTER.getAbSegmentIdsBySectionId()
                .get(MetrikaCountersData.DEFAULT_COUNTER.getFirstAbSectionId());
        List<AbSegmentsDimension> statDimensions = campaign.getStatDimensions();
        AbSegmentsDimension expectedAbSegmentsDimension = new AbSegmentsDimension()
                .withDimensionId(MetrikaCountersData.DEFAULT_COUNTER.getFirstAbSectionId())
                .withSegments(segmentIds);

        assertThat("значения параметров, связанных с Аб-сегментами, соответствуют ожидаемым", statDimensions,
                beanDiffer(singletonList(expectedAbSegmentsDimension)).useCompareStrategy(onlyExpectedFields()));
    }

}
