package ru.yandex.autotests.directintapi.bstransport.main.campaign.absegments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.AbSegmentMultiplier;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.AbSegmentMultiplierData;
import ru.yandex.autotests.direct.cmd.data.commons.adjustment.HierarchicalMultipliers;
import ru.yandex.autotests.direct.cmd.data.counters.MetrikaCountersData;
import ru.yandex.autotests.direct.cmd.data.savecamp.SaveCampRequest;
import ru.yandex.autotests.direct.cmd.rules.BannersRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра StatDimensions, TargetDimensions, CoefDimensions (активные эксперименты) при недоступности эксперимента")
@Stories(StoriesNames.CAMPAIGN_PARAMS_AB_SEGMENTS)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfAbSegmentUnavailableGoalTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    //данный эксперимент должен использоваться только в этом тесте, т.к. есть установка IsAccessible
    // а при сохранении эксп. берется существующие условие из базы, если сегменты совпадают
    private static final Long SECTION_ID = 4L;
    private static final List<Long> SEGMENT_IDS = Arrays.asList(2500000009L, 2500000010L);

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);
    private static int shard;

    private BannersRule bannersRule = new TextBannersRule()
            .overrideCampTemplate(new SaveCampRequest()
                    .withMetrika_counters(MetrikaCountersData.DEFAULT_COUNTER.getCounterId().toString())
                    .withAbSectionsStat(singletonList(SECTION_ID))
                    .withAbSegmentsRetargeting(SEGMENT_IDS)
                    .withHierarchicalMultipliers(new HierarchicalMultipliers()
                            .withAbSegmentMultiplier(new AbSegmentMultiplier()
                                    .withEnabled(true)
                                    .withAbSegments(asList(new AbSegmentMultiplierData()
                                            .withSectionId(SECTION_ID)
                                            .withSegmentId(SEGMENT_IDS.get(0))
                                            .withMultiplierPct("130"), new AbSegmentMultiplierData()
                                            .withSectionId(SECTION_ID)
                                            .withSegmentId(SEGMENT_IDS.get(1))
                                            .withMultiplierPct("140"))))))
            .withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {

        CampaignsRecord record = TestEnvironment.newDbSteps().useShard(shard).campaignsSteps()
                .getCampaignById(bannersRule.getCampaignId());
        TestEnvironment.newDbSteps().useShard(shard).campaignsSteps().updateCampaigns(record);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(record.getAbSegmentStatRetCondId(), SEGMENT_IDS.get(0), 0);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(record.getAbSegmentRetCondId(), SEGMENT_IDS.get(0), 0);
    }

    @Test
    @Title("Отправка в БК параметов экспериментальных сегменов (активные эксперименты) при наличии недоступной цели")
    public void testTransportOfDimensionsUnavailableGoal() {
        Long cid = bannersRule.getCampaignId();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        assertThat("в БК отправлен StatDimensions со значением [] на уровне кампании",
                (ArrayList) helpSteps.getOrderMap(resp, cid).get(Campaign.STAT_DIMENSIONS), empty());
        assertThat("в БК отправлен TargetDimensions со значением [] на уровне кампании",
                (ArrayList) helpSteps.getOrderMap(resp, cid).get(Campaign.TARGET_DIMENSIONS), empty());
        assertThat("в БК отправлен CoefDimensions со значением [] на уровне кампании",
                (ArrayList) helpSteps.getOrderMap(resp, cid).get(Campaign.COEF_DIMENSIONS), empty());
    }

}
