package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.archiving.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_AGENCY;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_MNGR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author: xy6er
 * https://st.yandex-team.ru/TESTIRT-10043
 */

@Issue("https://st.yandex-team.ru/DIRECT-55773")
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК заархивированной кампании с минусами, у которого подключен общий счет")
@Stories(StoriesNames.CAMPAIGN_ACTION_ARCHIVE)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfArchivedCampaignWithWalletAndMinusTest {

    private static final float WALLET_SUM = 1234;
    private static final float SUM_SPENT = WALLET_SUM / 2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(LOGIN_AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static Long cid;
    private static Campaign campaign;


    @BeforeClass
    public static void beforeClass() {
        // создаем клиента с кампанией
        api.userSteps.clientFakeSteps().enableToCreateSubClients(LOGIN_AGENCY);
        api.userSteps.clientFakeSteps().enableAgencyWallet(LOGIN_AGENCY);
        CreateNewSubclientResponse createNewSubclientResponse = api.userSteps.clientSteps()
                .createNewServicedSubClient("transport-wallet-", LOGIN_MNGR, Currency.RUB);
        String login = createNewSubclientResponse.getLogin();
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, login);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid, login);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(login, pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(cid);

        long walletCid = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid).getWalletCid();
        api.userSteps.campaignFakeSteps().setCampaignSum(walletCid, WALLET_SUM);
        // отправляем кампанию-кошелек
        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, walletCid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        api.userSteps.campaignSteps().campaignsSuspend(login, cid);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        api.userSteps.getDirectJooqDbSteps().campaignsSteps().makeCampaignReadyForArchive(cid);
        api.userSteps.campaignFakeSteps().setSumSpent(cid, SUM_SPENT);
        api.userSteps.campaignSteps().campaignsArchive(login, cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
    }


    @Test
    @Title("Отправка в БК архивации кампании с минусами, у которого подключен общий счет")
    public void testTransportForArchivedCampaignWithWalletAndMinus() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setStop(StopFlag.STOP.value());
        expectedCampaign.setArchive(1);
        assertThat("данные отправки заархивированной кампании не соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }
}
