package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.queue;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.beanDifferForBsExportQueue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultBsExportQueueRecord;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Постановка в очередь новой кампании, уже добавленной полным реэкспортом")
@Description("Предусловие: кампания уже добавленна в bs_export_queue скриптом полного реэкспорта. (full_lb_export = 1)" +
        "Проверяем обновление записи в bs_export_queue скриптом bsExportMaster.pl")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.FULL_EXPORT, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueCampaignAlreadyProcessedByFullLBExportTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Постановка в очередь новой кампании(без баннеров), уже добавленной полным реэкспортом")
    public void testAddingToBsQueueCampaignProceededWithFullLBExport() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        //ставим кампанию в очередь скриптом полного реэкспорта
        api.userSteps.getDarkSideSteps().getBsExportSteps().addCampaignToFullExportQueue(cid);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        assumeThat("лог отправки непустой",
                response, notNullValue());
        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assumeThat("запущенная кампания отправилась в БК", campaign, notNullValue());
        BsExportQueueRecord campInExportQueue = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .transportSteps().getBsExportQueueRecord(cid);

        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для запущенной кампании",
                campInExportQueue, new QueueRecordMatcher()
                        .withFullExport()
        );
    }
}
