package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.queue;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "новой пустой кампании")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewCampaignWithNoBannersTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().setAPIUnits(LOGIN, 12000000);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Добавление в очередь новой кампании без баннеров")
    public void testAddingToBsQueueOfNewCampaignWithNoBanners() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК была отправлена кампания", campaign, notNullValue());
    }
}
