package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка отправки в БК кампании с принятыми объектами в зависимости от статуса statusPostModerate")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class AddingToBsQueueNewFilledCampaignModerationTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter(0)
    public String testStatus;

    @Parameterized.Parameter(1)
    public boolean shouldBeSentToBS;

    @Parameterized.Parameters(name = "Статус кампании statusPostModerate = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                // В БК в первый раз (OrderID = 0) отправляются только кампании со statusPostModerate = Accepted
                // см https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/Export.pm#L1030
                {Status.NEW, false},
                {Status.YES, false},
                {Status.NO, false},
                {Status.ACCEPTED, true}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().setAPIUnits(LOGIN, 12000000);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Добавление в очередь новой кампании с принятой группой в зависимости от статуса модерации")
    public void testBsTransportForNewFilledCampaignWithMoneyModeration() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setCampaignSum(cid, 10000f);

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().setStatusModerate(cid, Status.YES);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        // Статус постмодерации нужно ставить после создания отмодерированных баннеров
        // в противном случае ручка FakeAdmin_FakeBannerParams перезатрёт его, установив Accepted
        api.userSteps.campaignFakeSteps().setStatusPostModerate(cid, testStatus);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        if (shouldBeSentToBS) {
            assumeThat("Лог отправки непустой", response, notNullValue());
            Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
            assertThat("Ожидаем, что в БК была отправлена кампания", campaign, notNullValue());
        } else {
            assumeThat("Лог отправки пустой", response, nullValue());
        }
    }
}
