package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.receive;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новой остановленной пустой кампании")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewStoppedCampaignWithNoBannersTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Campaign campaignResp1;

    private static CampaignsRecord campaignDb;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        api.userSteps.campaignSteps().campaignsSuspend(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaignResp1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);

        campaignDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
    }

    @Test
    @Title("Изменения после успешной отправки новой остановленной кампании без баннеров - " +
            "статус statusBsSynced Кампании")
    public void testCampaignSyncStatusAfterTransmissionOfNewStoppedCampaignWithNoBanners() {
        assertThat("после синхронизации кампании statusBsSynced = Yes",
                campaignDb.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после успешной отправки новой остановленной кампании без баннеров - " +
            "OrderID Кампании")
    public void testOrderIdAfterTransmissionOfNewStoppedCampaignWithNoBanners() {
        String orderId = campaignResp1.getId();
        assumeThat("БК вернула OrderId", orderId, not(isEmptyOrNullString()));

        assertThat("правильный OrderID у кампании после синхронизации",
                campaignDb.getOrderid().toString(), equalTo(orderId));
    }
}
