package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.transmit.moderation;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК новой кампании без принятых групп")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewCampaignWithNotAcceptedGroupsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static RunBsTransportScriptResponse resp;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        resp = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        assumeThat("Ожидаем, что в БК была отправлена кампания", campaign, notNullValue());
    }

    @Test
    @Title("Отправка в БК новой кампании без принятых групп (1 запрос) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjReq1ForNewCampaignWithNotAcceptedGroups() {
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, helpSteps.campaignReq1Matcher(cid, shard));
    }

    @Test
    @Title("Отправка в БК новой кампании без принятых групп (1 запрос) - " +
            "проверка списка Контекстов")
    public void testTransportOfContextListObjReq1ForNewCampaignWithNotAcceptedGroups() {
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Map<String, Context> contexts =
                campaign != null &&
                        campaign.getContexts() != null &&
                        campaign.getContexts().size() > 0 ?
                        campaign.getContexts() : null;
        assertThat("в БК отправлен пустой список групп", contexts, nullValue());
    }

    @Test
    @Title("Отправка в БК новой кампании без принятых групп (2 запрос) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjReq2ForNewCampaignWithNotAcceptedGroups() {
        String orderId = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid).getId();
        assumeThat("БК вернуло OrderId", orderId, not(isEmptyOrNullString()));

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setId(orderId);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК новой кампании без принятых групп (2 запрос) - " +
            "проверка списка Контекстов")
    public void testTransportOfContextListObjReq2ForNewCampaignWithNotAcceptedGroups() {
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        Map<String, Context> contexts =
                campaign != null &&
                        campaign.getContexts() != null &&
                        campaign.getContexts().size() > 0 ?
                        campaign.getContexts() : null;
        assertThat("в БК отправлен пустой список групп", contexts, nullValue());
    }
}
