package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.transmit.requests;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum.FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED;
import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum.FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.CONTEXT_RELEVANCE_MATCH;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК флага кампании isExtendedRelevanceMatchEnabled")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportCampaignExtendedRelevanceMatchFlagTest {

    private static final String login = Logins.LOGIN_TRANSPORT_IMG_WIDE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static RunBsTransportScriptResponse resp;

    private static long featureOneId;

    private static long featureTwoId;

    private static long clientId;

    private Campaign campaign;

    @Parameterized.Parameter(0)
    public boolean clientHasExtendedRelevanceMatch;

    @Parameterized.Parameter(1)
    public boolean extendedRelevanceMatchInterfaceOnly;

    @Parameterized.Parameter(2)
    public int expectedFlagValue;

    @Parameterized.Parameter(3)
    public CampaignType campaignType;

    @Parameterized.Parameters(name = "Тип кампании: {3}, clientHasExtendedRelevanceMatch = {0}, extendedRelevanceMatchInterfaceOnly = {1}, isExtendedRelevanceMatchEnabled = {2}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false, false, 1, CampaignType.TEXT},
                {false, true,  1, CampaignType.TEXT},
                {true,  false, 1, CampaignType.TEXT},
                {true,  true,  1, CampaignType.TEXT},
                {true,  true,  1, CampaignType.MOBILE_CONTENT},
                {true,  false, 1, CampaignType.MOBILE_CONTENT},
                {false, true,  1, CampaignType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        featureOneId = api.userSteps.getDirectJooqDbSteps().featuresSteps().getFeatureId(CONTEXT_RELEVANCE_MATCH.getValue());
        featureTwoId = api.userSteps.getDirectJooqDbSteps().featuresSteps().getFeatureId(CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY.getValue());
        clientId = Long.valueOf(User.get(login).getClientID());
    }

    @Before
    public void before(){
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, featureOneId, clientHasExtendedRelevanceMatch);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, featureOneId, extendedRelevanceMatchInterfaceOnly);
        if (clientHasExtendedRelevanceMatch){
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .setClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED);
        }
        else {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .dropClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_ALLOWED);
        }
        if (extendedRelevanceMatchInterfaceOnly){
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .setClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY);
        }
        else {
            api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps()
                    .dropClientFlag(clientId, FEATURE_CONTEXT_RELEVANCE_MATCH_INTERFACE_ONLY);
        }
        cid = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, defineAdGroupTypeByCampaignType(campaignType));
        Long bid = api.userSteps.adsSteps().addDefaultAd(pid, defineBannerTypeByCampaignType(campaignType));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
    }

    @Test
    @Title("Клиентская фича 'Расширенный автотаргетинг' включена: {0}, ожидаемое значение isExtendedRelevanceMatchEnabled: {1}")
    public void testIsExtendedRelevanceMatchEnabledValue() {
        assertThat("значение флага isExtendedRelevanceMatchEnabled соответствует ожидаемому",
                campaign.getIsExtendedRelevanceMatchEnabled(), equalTo(expectedFlagValue));
    }

    private BannerType defineBannerTypeByCampaignType(CampaignType campaignType){
        if (campaignType == CampaignType.MOBILE_CONTENT) {
            return BannerType.MOBILE_CONTENT;
        }
        return BannerType.TEXT;
    }

    private AdGroupType defineAdGroupTypeByCampaignType(CampaignType campaignType){
        if (campaignType == CampaignType.MOBILE_CONTENT) {
            return AdGroupType.MOBILE_CONTENT;
        }
        return AdGroupType.BASE;
    }
}
