package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.transmit.requests;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.direct.utils.features.FeatureNameEnum.CONTEXT_RELEVANCE_MATCH;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК флага кампании isExtendedRelevanceMatchEnabled для new РМП кампаний")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportNewRmpEnabledFlagTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT_NEW_RMP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static long contextRelevanceMatchFeatureId;
    private static long clientId;

    private Campaign campaign;

    @Parameterized.Parameter
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public int expectedFlagValue;


    @Parameterized.Parameters(name = "Тип кампании: {0}, isExtendedRelevanceMatchEnabled = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, 1},
                {CampaignType.MOBILE_CONTENT, 1},
        });
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        contextRelevanceMatchFeatureId = api.userSteps.getDirectJooqDbSteps().featuresSteps()
                .getFeatureId(CONTEXT_RELEVANCE_MATCH.getValue());
        clientId = Long.valueOf(User.get(LOGIN).getClientID());
    }

    @Before
    public void before() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsSteps()
                .setClientFeature(clientId, contextRelevanceMatchFeatureId, false);

        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(campaignId);

        Long adGroupId = api.userSteps.adGroupsSteps()
                .addDefaultGroup(campaignId, defineAdGroupTypeByCampaignType(campaignType));
        Long adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, defineBannerTypeByCampaignType(campaignType));
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(adId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        if (campaignType == CampaignType.MOBILE_CONTENT) {
            // Подстановка приложения в РМП кампанию проверяется в API тестах, но здесь функционирование
            // транспорта может зависеть от заполенного в кампании приложения, поэтому на всякий случай проверим
            Long campaignMobileAppId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                    .campaignsSteps().getCampaignMobileAppId(campaignId);
            assumeThat("Для РМП кампании указано приложение", campaignMobileAppId, not(equalTo(0)));
        }

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, campaignId);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, campaignId);
    }

    @Test
    public void testIsExtendedRelevanceMatchEnabledValue() {
        assertThat("значение флага isExtendedRelevanceMatchEnabled соответствует ожидаемому",
                campaign.getIsExtendedRelevanceMatchEnabled(), equalTo(expectedFlagValue));
    }

    private static BannerType defineBannerTypeByCampaignType(CampaignType campaignType) {
        if (campaignType == CampaignType.MOBILE_CONTENT) {
            return BannerType.MOBILE_CONTENT;
        }
        return BannerType.TEXT;
    }

    private static AdGroupType defineAdGroupTypeByCampaignType(CampaignType campaignType) {
        if (campaignType == CampaignType.MOBILE_CONTENT) {
            return AdGroupType.MOBILE_CONTENT;
        }
        return AdGroupType.BASE;
    }
}
