package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.creation.transmit.requests;

import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsMetatype;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки/неотправки в БК CounterID")
@Stories(StoriesNames.CAMPAIGN_ACTION_CREATION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewCampaignCounterIDTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    public void testNoCounterId() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> campaign = helpSteps.getOrderMap(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assertThat("в БК не отправилось поле CounterID", campaign.keySet(), not(hasItem(Campaign.COUNTER_ID)));
    }

    @Test
    public void testWithCounterId() {
        Integer counterId = RandomUtils.getRandomInteger(31337, 100500);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).metrikaCountersSteps()
                .createMetrikaCounters(cid, counterId.longValue(), 0, null);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> campaign = helpSteps.getOrderMap(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assertThat("в БК не отправилось поле CounterID", campaign.keySet(), not(hasItem(Campaign.COUNTER_ID)));
    }

    @Test
    public void testWithCounterId_ForEcomCampaign() {
        Integer counterId = RandomUtils.getRandomInteger(31337, 100500);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).metrikaCountersSteps()
                .createMetrikaCounters(cid, counterId.longValue(), 0, null);
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().setCampaignMetaType(cid, CampaignsMetatype.ecom);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assertThat("в БК отправился правильный CounterID", campaign.getCounterID(), equalTo(counterId));
    }
}
