package ru.yandex.autotests.directintapi.bstransport.main.campaign.actions.unarchiving.transmit;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК разархивированной кампании")
@Stories(StoriesNames.CAMPAIGN_ACTION_UNARCHIVING)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfUnarchivedCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long bidsId;
    private static Long retId;
    private static Long bid;

    private static Campaign campaign;
    private static Context context;
    private static Phrase phrase;
    private static GoalContext goalContext;
    private static Banner banner;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        Long retCondId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(0);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidsId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId);
        retId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, retCondId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.campaignSteps().campaignsSuspend(cid);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        api.userSteps.getDirectJooqDbSteps().campaignsSteps().makeCampaignReadyForArchive(cid);
        api.userSteps.campaignSteps().campaignsArchive(cid);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        api.userSteps.campaignSteps().campaignsUnarchive(cid);

        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .transportSteps().getBsExportQueueRecord(cid);
        assumeThat("в таблице ppc.bs_export_queue присутствует правильная запись " +
                        "для разархивированной кампании",
                campInExportQueue, new QueueRecordMatcher()
                        .withCamps()
                        .withoutPrices()
                        .withContexts()
                        .withBids()
                        .withBanners()
                        .withoutFullExport()
        );

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrase = context != null ? context.getPhrase(bidsId) : null;
        goalContext = context != null ? context.getGoalContext(retId) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Отправка в БК разархивации кампании - проверка объекта Кампания")
    public void testTransportOfCampaignObjForUnarchivedCampaign() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setStop(StopFlag.STOP.value());
        expectedCampaign.setArchive(0);
        assertThat("отправленные данные разархивированной кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК разархивации кампании - проверка объекта Контекст")
    public void testTransportOfContextObjForUnarchivedCampaign() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные данные контекста в разархивированной кампании соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК разархивации кампании - проверка объекта Фраза")
    public void testTransportOfPhraseObjForUnarchivedCampaign() {
        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(bidsId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные данные фразы в разархивированной кампании соответствуют ожидаемым",
                phrase, beanEquals(expectedPhrase));
    }

    @Test
    @Title("Отправка в БК разархивации кампании - проверка объекта Ретаргетинг")
    public void testTransportOfGoalContextObjForUnarchivedCampaign() {
        GoalContext expectedGoalContext =
                helpSteps.buildExpectedRetargetingObjFromDb(retId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные данные ретаргетинга в разархивированной кампании соответствуют ожидаемым",
                goalContext, beanEquals(expectedGoalContext));
    }

    @Test
    @Title("Отправка в БК разархивации кампании - проверка объекта Баннер")
    public void testTransportOfBannerObjForUnarchivedCampaign() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные данные баннера в разархивированной кампании соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }
}
