package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.advancedgeotargeting;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-166941")
@Title("Транспорт: отправка новых параметров расширенного геотаргетинга")
@Stories(StoriesNames.CAMPAIGN_PARAMS_ADVANCED_GEO)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportAdvancedGeoTargetingTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String PPC_PROPERTY_NAME = "BS_TRANSPORT_SEND_ADVANCED_GEOTARGETING_DATA";

    private static DirectJooqDbSteps dbSteps;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public int advancedGeotargetingProperty;

    @Parameterized.Parameter(2)
    public String dbCampaignOptsValue;

    @Parameterized.Parameter(3)
    public Integer expectedStatusUseCurrentRegion;

    @Parameterized.Parameter(4)
    public Integer expectedStatusUseRegularRegion;

    @Parameterized.Parameters(name = "тип кампании - {0}, проперти - {1}, opts - \"{2}\"")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.text, 1, "use_current_region,use_regular_region", 1, 1},
                {CampaignsType.cpm_banner, 1, "use_current_region", 1, 0},
                {CampaignsType.content_promotion, 1, "use_regular_region", 0, 1},
                {CampaignsType.performance, 1, "", 1, 1},
                {CampaignsType.dynamic, 1, "use_current_region,use_regular_region", 1, 1},
                {CampaignsType.mcbanner, 0, "use_current_region,use_regular_region", null, null},
                {CampaignsType.dynamic, 0, "use_current_region,use_regular_region", null, null},
                {CampaignsType.cpm_yndx_frontpage, 1, "use_current_region,use_regular_region", null, null},
        };
        return Arrays.asList(data);
    }

    private static int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(login);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        dbSteps.ppcPropertiesSteps()
                .updatePropertyValue(PPC_PROPERTY_NAME, String.valueOf(advancedGeotargetingProperty));
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignsRecord co = dbSteps.campaignsSteps().getCampaignById(cid);
        co.setType(campaignsType);
        co.setOpts(dbCampaignOptsValue);
        dbSteps.campaignsSteps().updateCampaigns(co);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }


    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp = api.userSteps.
                getDarkSideSteps()
                .getTransportSteps()
                .sendCampaign(shard, cid);
        Campaign campaign = api.userSteps
                .getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        assertThat(
                "при отправке кампании  отправляется правильное значение statusUseCurrentRegion",
                campaign.getStatusUseCurrentRegion(),
                equalTo(expectedStatusUseCurrentRegion)
        );
        assertThat(
                "при отправке кампании  отправляется правильное значение statusUseRegularRegion",
                campaign.getStatusUseRegularRegion(),
                equalTo(expectedStatusUseRegularRegion)
        );
    }

}
