package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.asap;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.ScriptParamsProfiles;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-112494")
@Title("Транспорт: отправка параметра быстрой доставки кампании до показов")
@Stories(StoriesNames.CAMPAIGN_PARAMS_ASAP)
@Features(FeatureNames.CAMPAIGNS)
@RunWith(Parameterized.class)
public class BsTransportAsapTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_SMALL;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public boolean asapFlagSet;

    @Parameterized.Parameter(2)
    public Integer expectedSendingValue;

    @Parameterized.Parameters(name = "Тип кампании - {0}, отправляемое значение - {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.text, true, 1},
                {CampaignsType.dynamic, true, 1},
                {CampaignsType.mobile_content, true, 1},
                {CampaignsType.performance, true, 1},

                {CampaignsType.text, false, null},
                {CampaignsType.dynamic, false, null},
                {CampaignsType.mobile_content, false, null},
                {CampaignsType.performance, false, null},
        };
        return Arrays.asList(data);
    }

    private int shard;
    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    public void setUp() {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        Long clientId = jooqDbSteps.shardingSteps().getClientIdByLogin(LOGIN);
        shard = jooqDbSteps.getCurrentPpcShard();

        if (asapFlagSet) {
            jooqDbSteps.clientsOptionsSteps().setClientFlag(clientId, ClientsOptionsSteps.ClientFlagsEnum.AS_SOON_AS_POSSIBLE);
        } else {
            jooqDbSteps.clientsOptionsSteps().dropClientFlag(clientId, ClientsOptionsSteps.ClientFlagsEnum.AS_SOON_AS_POSSIBLE);
        }

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setType(cid, campaignsType);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    public void testTransportOfDirectCampaignTypeTest() {
        RunBsTransportScriptResponse resp;
        if (asapFlagSet) {
            resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                    .sendNewCampaignWithProfile(shard, cid, ScriptParamsProfiles.ProfileNames.AS_SOON_AS_POSSIBLE);
        } else {
            resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        }

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, cid);
        assumeThat("Кампания отправляется в БК", campaign, notNullValue());
        assertThat("При отправке кампании в БК отправляется правильное значение IsPriorityCampaign",
                campaign.getIsPriorityCampaign(), is(expectedSendingValue));
    }
}
