package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.attributionmodel;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/TESTIRT-11675")
@Title("Транспорт: проверка отправки параметра attribution_model")
@Stories(StoriesNames.CAMPAIGN_PARAMS_ATTRIBUTION_MODEL)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)

/*
ВАЖНО!
В директе поле про аттрибуционную модель называется "attribution_model", в то время как в БК оно передается под именем AttributionType.
 */

public class BsTransportOfAttributionModelTest {
    private static final String login = Logins.LOGIN_TRANSPORT;

    private static final String MODEL_LAST_CLICK = "last_click";                           // at BK AttributionType = 1
    private static final String MODEL_FIRST_CLICK = "first_click";                         // at BK AttributionType = 3
    private static final String MODEL_LAST_SIGNIFICIANT_CLICK = "last_significant_click"; // at BK AttributionType = 2
    private static final String MODEL_LAST_YANDEX_DIRECT_CLICK = "last_yandex_direct_click"; // at BK AttributionType = 4
    private static final String MODEL_LAST_SIGNIFICIANT_CLICK_CROSS_DEVICE = "last_significant_click_cross_device"; // at BK AttributionType = 5
    private static final String MODEL_FIRST_CLICK_CROSS_DEVICE = "first_click_cross_device"; // at BK AttributionType = 6
    private static final String MODEL_LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE = "last_yandex_direct_click_cross_device"; // at BK AttributionType = 7

    private static Campaign campaign;

    protected DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Parameterized.Parameter(0)
    public String attributionModel = null;

    @Parameterized.Parameter(1)
    public Integer expectedAttributionModel = null;

    @Parameterized.Parameters(name = "Модель аттрибуции = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {null, 7},                  // если не передали поле то будет дефолтное поведение
                {MODEL_LAST_CLICK, 1},
                {MODEL_FIRST_CLICK, 3},
                {MODEL_LAST_SIGNIFICIANT_CLICK, 2},
                {MODEL_LAST_YANDEX_DIRECT_CLICK, 4},
                {MODEL_LAST_SIGNIFICIANT_CLICK_CROSS_DEVICE, 5},
                {MODEL_FIRST_CLICK_CROSS_DEVICE, 6},
                {MODEL_LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE, 7}
        };
        return Arrays.asList(data);
    }

    @Before
    public void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid))
        );
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        jooqDbSteps.campaignsSteps().setAttributionModel(cid, attributionModel);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
    }

    @Test
    @Title("Отправка в БК кампании с заполненным параметром attribution_model")
    @Description("Поле в таблице campaigns.attribution_model заполнено null/last_click/first_click/last_singnifician_click; Ожидаем присутствие поля в транспорте БК со значениями 1-3.")
    public void testTransportOfAttributionModel() {

        assertThat("при отправке кампании с моделью аттрибуции отправляется правильное значение AttributionType"
                , campaign.getAttributionType(), equalTo(expectedAttributionModel));
    }

}
