package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.autobudgetnetcpcoptimize;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 26/08/15.
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра удержание CPC в РСЯ для ручных стратегий с дневным бюджетом")
@Stories(StoriesNames.CAMPAIGN_PARAMS_CPC_HOLD)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfAutoBudgetNetCPCOptimizeWithDailyBudgetTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final float DAY_BUDGET_AMOUNT = 350;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(1)
    public TextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(2)
    public YesNoEnum enableCPCHold;

    @Parameterized.Parameter(3)
    public int expectedAutoBudgetNetCPCOptimize;

    @Parameterized.Parameters(name = "стратегия на поиске = {0}, стратегия на сети = {1}, enableCPCHold = {2}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(), YesNoEnum.NO, 0},
                //https://st.yandex-team.ru/DIRECT-54131
                {new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(), YesNoEnum.YES, 0},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    public void testTransportAutoBudgetNetCPCOptimize() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDailyBudget(new DailyBudgetMap()
                        .withAmount(Money.valueOf(DAY_BUDGET_AMOUNT).bidLong().longValue())
                        .withMode(DailyBudgetModeEnum.STANDARD))
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))
                        .withSettings(new TextCampaignSettingMap()
                                .withOption(TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                                .withValue(enableCPCHold))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("кампания отправлена в БК", campaign, notNullValue());

        Campaign expectedCampaign = new Campaign();
        expectedCampaign.setAutoBudget(1);
        expectedCampaign.setAutoBudgetNetCPCOptimize(expectedAutoBudgetNetCPCOptimize);
        expectedCampaign.setDiscountHistory(null);
        expectedCampaign.setNdsHistory(null);
        assertThat("в БК отправленно ожидаемые поля AutoBudget и AutoBudgetNetCPCOptimize",
                campaign,
                beanDiffer(expectedCampaign).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}

