package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.autobudgetnetcpcoptimize;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 26/08/15.
 * https://st.yandex-team.ru/TESTIRT-6860
 * https://st.yandex-team.ru/TESTIRT-10015
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки включенного параметра удержание CPC в РСЯ")
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-45094"), @Issue("https://st.yandex-team.ru/DIRECT-54131")})
@Stories(StoriesNames.CAMPAIGN_PARAMS_CPC_HOLD)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfEnabledAutoBudgetNetCPCOptimizeTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;

    private Campaign campaign;

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyAddMap searchStrategy;
    @Parameterized.Parameter(1)
    public TextCampaignNetworkStrategyAddMap networkStrategy;
    @Parameterized.Parameter(2)
    public int expectedAutoBudget;
    @Parameterized.Parameter(3)
    public int expectedAutoBudgetNetCPCOptimize;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB)
                        , new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault()
                        , 1
                        , 0
                }
                ,
                {
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpc(Currency.RUB)
                        , new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault()
                        , 1
                        , 0
                }
                ,
                //https://st.yandex-team.ru/DIRECT-54131
                {
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition()
                        , new TextCampaignNetworkStrategyAddMap().defaultServingOff()
                        , 0
                        , 0
                }
                ,
                {
                        new TextCampaignSearchStrategyAddMap().defaultServingOff()
                        , new TextCampaignNetworkStrategyAddMap().defaultAverageCpc(Currency.RUB)
                        , 1
                        , 0
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))
                        .withSettings(new TextCampaignSettingMap()
                                .withOption(TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                                .withValue(YesNoEnum.YES))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("кампания отправлена в БК", campaign, notNullValue());
    }

    @Test
    public void testTransportAutoBudgetNetCPCOptimize() {
        Campaign expectedCampaign = new Campaign();
        expectedCampaign.setAutoBudget(expectedAutoBudget);
        expectedCampaign.setAutoBudgetNetCPCOptimize(expectedAutoBudgetNetCPCOptimize);
        expectedCampaign.setDiscountHistory(null);
        expectedCampaign.setNdsHistory(null);

        assertThat("в БК отправленно ожидаемые поля AutoBudget и AutoBudgetNetCPCOptimize",
                campaign,
                beanDiffer(expectedCampaign).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
