package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.billingaggregates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.ProductsType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BillingOrderRules;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BillingOrders;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Здесь проверяется факт отправки BillingOrders, если у клиента есть
 * соответствующие биллинговые агрегаты. Более детальные проверки
 * в юнит тестах /unit_tests/BS/ExportQuery/billing_aggregates.t
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-87419")
@Title("Транспорт: отправка биллинговых агрегатов")
@Stories(StoriesNames.CAMPAIGN_PARAMS_BILLINGAGGREGATES)
@Features({FeatureNames.CAMPAIGNS})
public class BsTransportBillingAggregatesTest {
    private static final String login = Logins.LOGIN_TRANSPORT_SUM_MIGRATION_3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    public void testCpmBannerBillingAggregates() {
        DirectJooqDbSteps dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard);
        TransportSteps transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();

        Long cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        Long walletId = dbSteps.campaignsSteps().getCampaignById(cid).getWalletCid();
        RunBsTransportScriptResponse resp = transportSteps.sendNewCampaign(shard, cid);
        Campaign campaign = transportSteps.getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        Map<Long, ProductsType> productTypesById = dbSteps.productsSteps().getAllProductTypesById();
        Map<ProductsType, Long> billingAggregateIds =
                dbSteps.billingAggregateSteps().getBillingAggregateIds(walletId, productTypesById);
        List<BillingOrderRules> billingOrders = new ArrayList<BillingOrderRules>(){{
            add(new BillingOrderRules(
                    billingAggregateIds.get(ProductsType.cpm_video),
                    Arrays.asList("VideoCreativeReach", "VideoCreativeReachNonSkippable")));
            add(new BillingOrderRules(
                    billingAggregateIds.get(ProductsType.cpm_outdoor),
                    Collections.singletonList("VideoCreativeReachOutdoor")));
            add(new BillingOrderRules(
                    billingAggregateIds.get(ProductsType.cpm_indoor),
                    Collections.singletonList("VideoCreativeReachIndoor")));
            add(new BillingOrderRules(
                    billingAggregateIds.get(ProductsType.cpm_audio),
                    Collections.singletonList("AudioCreativeReach")));
        }};
        BillingOrders expected = new BillingOrders(
                billingAggregateIds.get(ProductsType.cpm_banner),
                billingOrders
        );
        assertThat("при отправке кампании отправляется правильное значение BillingOrders"
                , campaign.getBillingOrders(), beanDiffer(expected));
    }
}
