package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.billingaggregates;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasKey;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Здесь проверяется остутствие ключа ORDER.BillingOrders, если у клиента нет
 * соответствующих биллинговых агрегатов.
 * Отсутствие агрегатов достигается захардкоженным запретом создания агрегатов
 * для конкретного тестового uid
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-87419")
@Title("Транспорт: неотправка архивных биллинговых агрегатов")
@Stories(StoriesNames.CAMPAIGN_PARAMS_BILLINGAGGREGATES)
@Features({FeatureNames.CAMPAIGNS})
public class BsTransportNoBillingAggregatesTest {
    private static final String login = Logins.LOGIN_ARCHIVED_BILLING_AGGREGATES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    public void testNoSendingOfArchivedBillingAggregates() {
        TransportSteps transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();

        Long cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        RunBsTransportScriptResponse resp = transportSteps.sendNewCampaign(shard, cid);

        Map<String, Map> rawResp = transportSteps.getRawClientDataLogRequestForCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", rawResp, notNullValue());
        assertThat("На уровне ORDER нет ключа BillingOrders", rawResp, not(hasKey("BillingOrders")));
    }
}
