package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.brandsafety;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра TargetingExpression для исключений Brand Safety")
@Stories(StoriesNames.CAMPAIGN_PARAMS_BRANDSAFETY)
@Features({FeatureNames.CAMPAIGNS})
@ParametersAreNonnullByDefault
public class BsTransportOfBrandSafetyTargetingExpressionTest {
    private static final String login = Logins.LOGIN_TRANSPORT;
    private static final String BRANDSAFETY_RET_COND_JSON = "[{\"goals\":[" +
            "{\"goal_type\":\"brandsafety\",\"goal_id\":4294967297,\"time\":0}," +
            "{\"goal_type\":\"brandsafety\",\"goal_id\":4294967310,\"time\":0}]," +
            "\"type\":\"not\",\"interest_type\":null,\"section_id\":null}]";
    private static final List<List<BsAtom>> BRANDSAFETY_TARGETING_EXPRESSION = Arrays.asList(
            Collections.singletonList(
                    new BsAtom("brand-safety-categories", "not equal", "2")
            ),
            Collections.singletonList(
                    new BsAtom("brand-safety-categories", "not equal", "16384")
            )
    );

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    DirectJooqDbSteps jooqDbSteps;
    int shard;
    long cid;
    long clientId;

    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(login).getClientID());
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    @Title("Отправка в параметра TargetingExpression при выставленных исключениях Brand Safety")
    public void testTargetingExpression_HaveBrandSafety() {
        addBrandSafety();
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        assertThat("отправляется правильное значение TargetingExpression",
                campaign.getTargetingExpression(), beanDiffer(BRANDSAFETY_TARGETING_EXPRESSION));
    }

    @Test
    @Title("Отправка в параметра TargetingExpression если нет исключений Brand Safety")
    public void testTargetingExpression_NoBrandSafety() {
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, ?> rawClientDataLogRequestForCampaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogRequestForCampaign(resp, cid,
                        0);
        assertThat("поле TargetingExpression не отправляется",
                rawClientDataLogRequestForCampaign.keySet(), not(hasItem("TargetingExpression")));
    }

    @Test
    @Title("Отправка в параметра TargetingExpression при отправке кампании с UpdateInfo == 0")
    public void testTargetingExpression_HasBrandSafety_NoUpdateInfo() {
        addBrandSafety();
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        long groupId = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(groupId);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(groupId);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        long bannerId = api.userSteps.adsSteps().addDefaultTextAd(groupId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bannerId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        assumeThat("Кампания отправлена с UpdateInfo == 0", campaign.getUpdateInfo(), is(0));
        assertThat("отправляется правильное значение TargetingExpression",
                campaign.getTargetingExpression(), beanDiffer(BRANDSAFETY_TARGETING_EXPRESSION));
    }

    // TODO: более честно выставлять исключения для brand safety на кампании GraphQL ручкой
    private void addBrandSafety() {
        RetargetingConditionsRecord record = new RetargetingConditionsRecord()
                .setClientid(clientId)
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.brandsafety)
                .setConditionName("brandsafety condition")
                .setConditionDesc("brandsafety categories")
                .setConditionJson(BRANDSAFETY_RET_COND_JSON)
                .setIsDeleted(0)
                .setProperties("negative");
        long condId = jooqDbSteps.retargetingConditionSteps().addRetargetingCondition(record, clientId);
        jooqDbSteps.campaignsSteps().setBrandSafetyRetCondId(cid, condId);
    }
}
