package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.broadmatch;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.RelevantPhrasesBudgetLimit;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ShowCondition;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра BroadMatchLimit (лимит бюджета по релевантным фразам)")
@Stories(StoriesNames.CAMPAIGN_PARAMS_BROADMATCH)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfBroadMatchLimitTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();

    private static int shard;

    private static final RelevantPhrasesBudgetLimit budgetLimit = RelevantPhrasesBudgetLimit.LIMIT_OFF;

    private static final TextCampaignAddItemMap textCampaignAddItemMap = new TextCampaignAddItemMap()
            .defaultTextCampaign().withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                    .withBudgetPercent(RelevantPhrasesBudgetLimit.LIMIT_100.apiRelevantPhrasesBudgetLimit()));

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка в БК параметра BroadMatchLimit (лимит бюджета по релевантным фразам)")
    public void testTransportOfBroadMatchLimit() {
        Long cid = createNewCamapaignAndReturnCid();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        ShowCondition showCondition = campaign.getShowCondition();
        ShowCondition expectedShowCondition = new ShowCondition();
        expectedShowCondition.setBroadMatchLimit(budgetLimit.transportBroadMatchLimit());

        assertThat("значения параметров, связанных с ДРФ, соответствуют ожидаемым", showCondition,
                beanDiffer(expectedShowCondition).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    private Long createNewCamapaignAndReturnCid() {
        return api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(textCampaignAddItemMap));
    }
}
