package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.convertationprecise;

import java.math.RoundingMode;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 23/09/15.
 * https://st.yandex-team.ru/TESTIRT-7220
 * https://st.yandex-team.ru/TESTIRT-7642
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-46309")
@Title("Транспорт: проверка округления при отправке параметров AutoBudgetMaxBid и AutoBudgetMaxBidCur")
@Stories(StoriesNames.CAMPAIGN_PARAMS_PRECISION)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfMaxBidPrecisionTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final float WEEKLY_BUDGET = 5000f;
    private static final Double MAX_PRICE = 50.0123456789;

    private Campaign campaign;

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        TextCampaignSearchStrategyAddMap searchStrategy =
                new TextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                        .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                .withWeeklySpendLimit(Money.valueOf(WEEKLY_BUDGET).bidLong().longValue())
                                .withBidCeiling(Money.valueOf(MAX_PRICE).bidLong().longValue()));
        TextCampaignNetworkStrategyAddMap networkStrategy =
                new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault();
        Long cid = api.userSteps.campaignSteps()
                .addDefaultTextCampaignWithStrategies(searchStrategy, networkStrategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().setAutobudgetBid(cid, MAX_PRICE);
        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().setAutobudgetBid(
                    strategyId, MAX_PRICE);
        }

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
    }

    @Test
    @Title("Округление параметра " + Campaign.AUTO_BUDGET_MAX_BID)
    public void testTransportOfAutoBudgetMaxBid() {
        Campaign expected = new Campaign();
        // здесь можно было бы также проверить значение AutoBudgetMaxBid,
        // но вычисление этого поля не пережило переход на НДС 20%, и теперь оно вычисляется неправильно.
        // Это сознательно решили не исправлять, см. https://st.yandex-team.ru/DIRECT-88492
        expected.setAutoBudgetMaxBidCur(Money.valueOf(MAX_PRICE, Currency.RUB)
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP).floatValue());
        expected.setNdsHistory(null);
        expected.setDiscountHistory(null);
        assertThat("при отправке в БК значения AutoBudgetMaxBid и AutoBudgetMaxBidCur ушли округленными",
                campaign, beanDiffer(expected).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
