package ru.yandex.autotests.directintapi.bstransport.main.campaign.parameters.daybudget;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки размера дневного бюджета")
@Stories(StoriesNames.CAMPAIGN_PARAMS_DAYBUDGET)
@Features({FeatureNames.CAMPAIGNS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfDayLimitForDayBudgetTest {

    private static final Money DAY_BUDGET_AMOUNT = Money.valueOf(350f);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public Currency currency;

    @Parameterized.Parameters(name = "логин = {0}, валюта = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_TRANSPORT, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    @Test
    @Title("Отправка в БК размера дневного бюджета")
    public void testTransportOfDayLimitForDayBudget() {
        api.as(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        TextCampaignSearchStrategyAddMap searchStrategy =
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition();
        TextCampaignNetworkStrategyAddMap networkStrategy =
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage();
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDailyBudget(new DailyBudgetMap()
                        .withAmount(DAY_BUDGET_AMOUNT.bidLong().longValue())
                        .withMode(DailyBudgetModeEnum.DISTRIBUTED))
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);

        Float actualDayLimit = currency == Currency.YND_FIXED ?
                campaign.getAutoBudgetDayLimitMoney() : campaign.getAutoBudgetDayLimitMoneyCur();
        Float expectedDayLimit = DAY_BUDGET_AMOUNT.addVAT(currency).floatValue();
        assertThat("отправленный в БК размер дневного бюджета соответствует ожидаемому",
                actualDayLimit,
                equalTo(expectedDayLimit));
    }
}
